/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.edc.query.CriterionOperatorRegistryImpl;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.spi.query.QueryResolver;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.StoreResult;

public abstract class InMemoryEntityStore<T> {
    protected final Map<String, T> store = new HashMap<String, T>();
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    protected final QueryResolver<T> queryResolver;
    protected final CriterionOperatorRegistry criterionOperatorRegistry = CriterionOperatorRegistryImpl.ofDefaults();

    protected InMemoryEntityStore() {
        this.queryResolver = this.createQueryResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResult<T> findById(String id) {
        this.lock.readLock().lock();
        try {
            T result = this.store.get(id);
            StoreResult storeResult = result == null ? StoreResult.notFound((String)"An entity with ID '%s' does not exist.".formatted(id)) : StoreResult.success(result);
            return storeResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResult<Void> create(T newObject) {
        this.lock.writeLock().lock();
        String id = this.getId(newObject);
        try {
            if (this.store.containsKey(id)) {
                StoreResult storeResult = StoreResult.alreadyExists((String)"An entity with ID %s already exists".formatted(id));
                return storeResult;
            }
            this.store.put(id, newObject);
            StoreResult storeResult = StoreResult.success(null);
            return storeResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResult<Collection<T>> query(QuerySpec querySpec) {
        this.lock.readLock().lock();
        try {
            Stream result = this.queryResolver.query(this.store.values().stream(), querySpec, Predicate::and, x -> true);
            StoreResult storeResult = StoreResult.success(result.toList());
            return storeResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResult<Void> update(T newObject) {
        this.lock.writeLock().lock();
        try {
            String id = this.getId(newObject);
            if (!this.store.containsKey(id)) {
                StoreResult storeResult = StoreResult.notFound((String)"An entity with ID '%s' does not exist.".formatted(id));
                return storeResult;
            }
            this.store.put(id, newObject);
            StoreResult storeResult = StoreResult.success();
            return storeResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public StoreResult<Void> deleteById(String id) {
        this.lock.writeLock().lock();
        try {
            if (!this.store.containsKey(id)) {
                StoreResult storeResult = StoreResult.notFound((String)"An entity with ID '%s' does not exist.".formatted(id));
                return storeResult;
            }
            this.store.remove(id);
            StoreResult storeResult = StoreResult.success();
            return storeResult;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected abstract String getId(T var1);

    protected abstract QueryResolver<T> createQueryResolver();
}

