/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.system.health;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Failure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HealthCheckResult
extends AbstractResult<Boolean, Failure, HealthCheckResult> {
    private String component;

    private HealthCheckResult(boolean successful, Failure failure) {
        super(successful, failure);
    }

    @Deprecated(since="0.7.0")
    public static HealthCheckResult success() {
        return new HealthCheckResult(true, null);
    }

    @Deprecated(since="0.7.0")
    public static HealthCheckResult failed(String ... errors) {
        List<String> errorList = Stream.of(errors).filter(Objects::nonNull).collect(Collectors.toList());
        return new HealthCheckResult(false, new Failure(errorList));
    }

    @Deprecated(since="0.7.0")
    public static HealthCheckResult failed(List<String> errors) {
        return new HealthCheckResult(false, new Failure(errors));
    }

    @Override
    @JsonProperty(value="isHealthy")
    @NotNull
    public Boolean getContent() {
        return (Boolean)super.getContent();
    }

    @Override
    @NotNull
    protected <R1 extends AbstractResult<C1, Failure, R1>, C1> R1 newInstance(@Nullable C1 content, @Nullable Failure failure) {
        return (R1)new HealthCheckResult(failure == null, failure);
    }

    public String getComponent() {
        return this.component;
    }

    public HealthCheckResult forComponent(String component) {
        this.component = component;
        return this;
    }

    public static class Builder {
        private String component;
        private boolean success = true;
        private Failure failure;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder success() {
            this.success = true;
            return this;
        }

        public Builder success(boolean success, String ... errors) {
            this.success = success;
            if (!success) {
                return this.failure(errors);
            }
            return this;
        }

        public Builder failure(String ... errors) {
            return this.failure(Arrays.asList(errors));
        }

        public Builder failure(Collection<String> errors) {
            List<String> errorList = errors.stream().filter(Objects::nonNull).toList();
            this.failure = new Failure(errorList);
            this.success = false;
            return this;
        }

        public Builder component(String component) {
            this.component = component;
            return this;
        }

        public HealthCheckResult build() {
            HealthCheckResult hc = new HealthCheckResult(this.success, this.failure);
            hc.component = Objects.requireNonNull(this.component, "Component name cannot be null");
            return hc;
        }
    }
}

