/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.system.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.configuration.Config;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigImpl
implements Config {
    static final Collector<Map.Entry<String, String>, ?, Map<String, String>> TO_MAP = Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    private final Map<String, String> entries;
    private final String rootPath;

    ConfigImpl(Map<String, String> entries) {
        this("", entries);
    }

    protected ConfigImpl(String rootPath, Map<String, String> entries) {
        Objects.requireNonNull(rootPath, "rootPath");
        this.entries = entries;
        this.rootPath = rootPath;
    }

    @Override
    public String getString(String key) {
        return this.getNotNullValue(key, this::getString);
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.entries.get(this.absolutePathOf(key));
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Integer getInteger(String key) {
        return this.getNotNullValue(key, this::getInteger);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.getParsed(key, defaultValue, "integer", Integer::parseInt);
    }

    @Override
    public Long getLong(String key) {
        return this.getNotNullValue(key, this::getLong);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return this.getParsed(key, defaultValue, "long", Long::parseLong);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getNotNullValue(key, this::getBoolean);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getParsed(key, defaultValue, "boolean", this::parseBoolean);
    }

    @Override
    public Config getConfig(String path) {
        String absolutePath = this.absolutePathOf(path);
        Map<String, String> filteredEntries = this.entries.entrySet().stream().filter(entry -> absolutePath.isEmpty() || ((String)entry.getKey()).startsWith(absolutePath + ".") || ((String)entry.getKey()).equals(absolutePath)).collect(TO_MAP);
        return new ConfigImpl(absolutePath, filteredEntries);
    }

    @Override
    public Config merge(Config other) {
        HashMap<String, String> all = new HashMap<String, String>();
        all.putAll(this.entries);
        all.putAll(other.getEntries());
        return new ConfigImpl("", Collections.unmodifiableMap(all));
    }

    @Override
    public Stream<Config> partition() {
        return this.getRelativeEntries().keySet().stream().map(it -> it.split("\\.")[0]).distinct().map(this::getConfig);
    }

    @Override
    public Map<String, String> getEntries() {
        return this.entries;
    }

    @Override
    public Map<String, String> getRelativeEntries() {
        return this.getEntries().entrySet().stream().map(entry -> Map.entry(this.removePrefix((String)entry.getKey(), this.rootPath), (String)entry.getValue())).collect(TO_MAP);
    }

    @Override
    public Map<String, String> getRelativeEntries(String basePath) {
        return this.getRelativeEntries().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(basePath)).collect(TO_MAP);
    }

    @Override
    public String currentNode() {
        String[] parts = this.rootPath.split("\\.");
        return parts[parts.length - 1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLeaf() {
        if (this.entries.size() != 1) return false;
        if (!this.entries.keySet().stream().allMatch(this.rootPath::equals)) return false;
        return true;
    }

    @Override
    public boolean hasKey(String key) {
        return this.getEntries().containsKey(key);
    }

    @Override
    public boolean hasPath(String path) {
        return this.getEntries().keySet().stream().anyMatch(it -> it.startsWith(path));
    }

    private boolean parseBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new EdcException(String.format("Cannot parse %s to boolean", value));
    }

    private String removePrefix(String path, String rootPath) {
        if (!rootPath.isEmpty() && path.startsWith(rootPath)) {
            return path.substring(rootPath.length() + 1);
        }
        return path;
    }

    @Nullable
    private <T> T getParsed(String key, T defaultValue, String typeDescription, Function<String, T> parse) {
        String value = this.getString(key, Objects.toString(defaultValue, null));
        if (value == null) {
            return null;
        }
        try {
            return parse.apply(value);
        }
        catch (Exception e) {
            throw new EdcException(String.format("Setting %s with value %s cannot be parsed to %s", this.absolutePathOf(key), value, typeDescription));
        }
    }

    @NotNull
    private <T> T getNotNullValue(String key, BiFunction<String, T, T> function) {
        T value = function.apply(key, null);
        if (value == null) {
            throw new EdcException(String.format("No setting found for key %s", this.absolutePathOf(key)));
        }
        return value;
    }

    @NotNull
    private String absolutePathOf(String key) {
        String rootPath = Optional.of(this.rootPath).filter(it -> !it.isEmpty()).map(it -> it + ".").orElse("");
        return rootPath + key;
    }
}

