/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.monitor;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import org.eclipse.edc.spi.monitor.Monitor;
import org.jetbrains.annotations.Nullable;

public class ConsoleMonitor
implements Monitor {
    private static final String SEVERE = "SEVERE";
    private static final String WARNING = "WARNING";
    private static final String INFO = "INFO";
    private static final String DEBUG = "DEBUG";
    private final boolean useColor;
    private final Level level;
    private final String prefix;

    public ConsoleMonitor() {
        this(true);
    }

    public ConsoleMonitor(boolean useColor) {
        this(null, Level.DEBUG, useColor);
    }

    public ConsoleMonitor(@Nullable String runtimeName, Level level) {
        this(runtimeName, level, true);
    }

    public ConsoleMonitor(@Nullable String runtimeName, Level level, boolean useColor) {
        this.prefix = runtimeName == null ? "" : "[%s] ".formatted(runtimeName);
        this.level = level;
        this.useColor = useColor;
    }

    @Override
    public void severe(Supplier<String> supplier, Throwable ... errors) {
        this.output(SEVERE, supplier, errors);
    }

    @Override
    public void warning(Supplier<String> supplier, Throwable ... errors) {
        if (Level.WARNING.value < this.level.value) {
            return;
        }
        this.output(WARNING, supplier, errors);
    }

    @Override
    public void info(Supplier<String> supplier, Throwable ... errors) {
        if (Level.INFO.value < this.level.value) {
            return;
        }
        this.output(INFO, supplier, errors);
    }

    @Override
    public void debug(Supplier<String> supplier, Throwable ... errors) {
        if (Level.DEBUG.value < this.level.value) {
            return;
        }
        this.output(DEBUG, supplier, errors);
    }

    private void output(String level, Supplier<String> supplier, Throwable ... errors) {
        String time = ZonedDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        String colorCode = this.useColor ? this.getColorCode(level) : "";
        String resetCode = this.useColor ? "\u001b[0m" : "";
        System.out.println(colorCode + this.prefix + level + " " + time + " " + this.sanitizeMessage(supplier) + resetCode);
        if (errors != null) {
            for (Throwable error : errors) {
                if (error == null) continue;
                System.out.print(colorCode);
                error.printStackTrace(System.out);
                System.out.print(resetCode);
            }
        }
    }

    private String getColorCode(String level) {
        return switch (level) {
            case SEVERE -> "\u001b[0;31m";
            case WARNING -> "\u001b[0;33m";
            case INFO -> "\u001b[0;32m";
            case DEBUG -> "\u001b[0;34m";
            default -> "";
        };
    }

    public static enum Level {
        SEVERE(3),
        WARNING(2),
        INFO(1),
        DEBUG(0);

        private final int value;

        private Level(int value) {
            this.value = value;
        }
    }
}

