/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.system.configuration;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.spi.system.configuration.ConfigImpl;

public class ConfigFactory {
    public static Config empty() {
        return new ConfigImpl(Collections.emptyMap());
    }

    public static Config fromMap(Map<String, String> settings) {
        return new ConfigImpl(settings);
    }

    public static Config fromProperties(Properties properties) {
        Map<String, String> entries = properties.entrySet().stream().map(it -> Map.entry(it.getKey().toString(), it.getValue().toString())).collect(ConfigImpl.TO_MAP);
        return new ConfigImpl(entries);
    }

    public static Config fromEnvironment(Map<String, String> environmentVariables) {
        Map<String, String> settings = environmentVariables.entrySet().stream().map(it -> Map.entry(((String)it.getKey()).toLowerCase().replace("_", "."), (String)it.getValue())).collect(ConfigImpl.TO_MAP);
        return new ConfigImpl(settings);
    }
}

