/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Failure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Result<T>
extends AbstractResult<T, Failure, Result<T>> {
    private Result(T content, Failure failure) {
        super(content, failure);
    }

    public static Result<Void> success() {
        return new Result<Object>(null, null);
    }

    public static <T> Result<T> success(@NotNull T content) {
        return new Result<T>(content, null);
    }

    public static <T> Result<T> failure(String failure) {
        return new Result<Object>(null, new Failure(List.of(failure)));
    }

    public static <T> Result<T> failure(List<String> failures) {
        return new Result<Object>(null, new Failure(failures));
    }

    public static <T> Result<T> ofThrowable(Supplier<T> supplier) {
        try {
            return Result.success(supplier.get());
        }
        catch (Exception e) {
            return Result.failure(e.getMessage());
        }
    }

    public static <T> Result<T> from(Optional<T> opt) {
        return opt.map(Result::success).orElse(Result.failure("Empty optional"));
    }

    public <R> Result<R> merge(Result<?> other) {
        if (this.succeeded() && other.succeeded()) {
            return new Result<Object>(null, null);
        }
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(Optional.ofNullable(this.getFailure()).map(Failure::getMessages).orElse(Collections.emptyList()));
        messages.addAll(Optional.ofNullable(other.getFailure()).map(Failure::getMessages).orElse(Collections.emptyList()));
        return Result.failure(messages);
    }

    public <R> Result<R> mapTo() {
        if (this.succeeded()) {
            return new Result<Object>(null, null);
        }
        return Result.failure(this.getFailureMessages());
    }

    public <R> Result<R> mapTo(Class<R> clazz) {
        return this.mapTo();
    }

    public Optional<T> asOptional() {
        return this.succeeded() && this.getContent() != null ? Optional.of(this.getContent()) : Optional.empty();
    }

    @Override
    @NotNull
    protected <R1 extends AbstractResult<C1, Failure, R1>, C1> R1 newInstance(@Nullable C1 content, @Nullable Failure failure) {
        return (R1)new Result<C1>(content, failure);
    }
}

