/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.result;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.edc.spi.result.Failure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractResult<T, F extends Failure, R extends AbstractResult<T, F, R>> {
    private final T content;
    private final F failure;

    protected AbstractResult(T content, F failure) {
        this.content = content;
        this.failure = failure;
    }

    public T getContent() {
        return this.content;
    }

    public F getFailure() {
        return this.failure;
    }

    @JsonIgnore
    public List<String> getFailureMessages() {
        return this.failure == null ? List.of() : ((Failure)this.failure).getMessages();
    }

    public boolean succeeded() {
        return this.failure == null;
    }

    public boolean failed() {
        return !this.succeeded();
    }

    @JsonIgnore
    public String getFailureDetail() {
        return this.failure == null ? null : ((Failure)this.failure).getFailureDetail();
    }

    public R onSuccess(Consumer<T> successAction) {
        if (this.succeeded()) {
            successAction.accept(this.getContent());
        }
        return this.self();
    }

    public R onFailure(Consumer<F> failureAction) {
        if (this.failed()) {
            failureAction.accept(this.getFailure());
        }
        return this.self();
    }

    public T orElse(Function<F, T> failureAction) {
        if (this.failed()) {
            return failureAction.apply(this.getFailure());
        }
        return this.getContent();
    }

    public <X extends Throwable> T orElseThrow(Function<F, X> exceptionMapper) throws X {
        if (this.failed()) {
            throw (Throwable)exceptionMapper.apply(this.getFailure());
        }
        return this.getContent();
    }

    public R self() {
        return (R)this;
    }

    public <T2, R2 extends AbstractResult<T2, F, R2>> R2 map(Function<T, T2> mapFunction) {
        if (this.succeeded()) {
            return (R2)this.newInstance(mapFunction.apply(this.getContent()), null);
        }
        return (R2)this.newInstance(null, this.getFailure());
    }

    public <T2, F2 extends Failure, R2 extends AbstractResult<T2, F2, R2>> R2 flatMap(Function<R, R2> mappingFunction) {
        return (R2)((AbstractResult)mappingFunction.apply(this.self()));
    }

    public <T2, R2 extends AbstractResult<T2, F, R2>> R2 compose(Function<T, R2> mappingFunction) {
        if (this.succeeded()) {
            return (R2)((AbstractResult)mappingFunction.apply(this.getContent()));
        }
        return (R2)this.newInstance(null, this.getFailure());
    }

    public R recover(Function<F, R> mappingFunction) {
        if (this.succeeded()) {
            return (R)this.newInstance(this.getContent(), null);
        }
        return (R)((AbstractResult)mappingFunction.apply(this.getFailure()));
    }

    @NotNull
    protected abstract <R1 extends AbstractResult<C1, F, R1>, C1> R1 newInstance(@Nullable C1 var1, @Nullable F var2);
}

