/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.system.health;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.system.health.HealthCheckResult;

public class HealthStatus {
    private final List<HealthCheckResult> componentResults;

    public HealthStatus(HealthCheckResult ... componentResults) {
        this.componentResults = List.of(componentResults);
    }

    public HealthStatus(Collection<HealthCheckResult> componentResults) {
        this.componentResults = List.copyOf(componentResults);
    }

    public List<HealthCheckResult> getComponentResults() {
        return this.componentResults;
    }

    @JsonProperty(value="isSystemHealthy")
    public boolean isHealthy() {
        if (this.componentResults.isEmpty()) {
            return false;
        }
        return this.componentResults.stream().allMatch(AbstractResult::succeeded);
    }
}

