/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.monitor;

import java.util.function.Supplier;
import org.eclipse.edc.spi.monitor.Monitor;

class PrefixMonitor
implements Monitor {
    private static final String MESSAGE_FORMAT = "[%s] %s";
    private final Monitor monitor;
    private final String prefix;

    PrefixMonitor(Monitor monitor, String prefix) {
        this.monitor = monitor;
        this.prefix = prefix;
    }

    @Override
    public void severe(Supplier<String> supplier, Throwable ... errors) {
        this.monitor.severe(() -> MESSAGE_FORMAT.formatted(this.prefix, supplier.get()), errors);
    }

    @Override
    public void severe(String message, Throwable ... errors) {
        this.monitor.severe(MESSAGE_FORMAT.formatted(this.prefix, message), errors);
    }

    @Override
    public void warning(Supplier<String> supplier, Throwable ... errors) {
        this.monitor.warning(() -> MESSAGE_FORMAT.formatted(this.prefix, supplier.get()), errors);
    }

    @Override
    public void warning(String message, Throwable ... errors) {
        this.monitor.warning(MESSAGE_FORMAT.formatted(this.prefix, message), errors);
    }

    @Override
    public void info(Supplier<String> supplier, Throwable ... errors) {
        this.monitor.info(() -> MESSAGE_FORMAT.formatted(this.prefix, supplier.get()), errors);
    }

    @Override
    public void info(String message, Throwable ... errors) {
        this.monitor.info(MESSAGE_FORMAT.formatted(this.prefix, message), errors);
    }

    @Override
    public void debug(Supplier<String> supplier, Throwable ... errors) {
        this.monitor.debug(() -> MESSAGE_FORMAT.formatted(this.prefix, supplier.get()), errors);
    }

    @Override
    public void debug(String message, Throwable ... errors) {
        this.monitor.debug(MESSAGE_FORMAT.formatted(this.prefix, message), errors);
    }
}

