/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.telemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.edc.spi.telemetry.InMemoryTraceCarrier;
import org.eclipse.edc.spi.telemetry.TraceCarrier;

public class Telemetry {
    private final OpenTelemetry openTelemetry;

    public Telemetry() {
        this.openTelemetry = OpenTelemetry.noop();
    }

    public Telemetry(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public Map<String, String> getCurrentTraceContext() {
        HashMap<String, String> traceContext = new HashMap<String, String>();
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), traceContext, Map::put);
        return traceContext;
    }

    public TraceCarrier getTraceCarrierWithCurrentContext() {
        return new InMemoryTraceCarrier(this.getCurrentTraceContext());
    }

    public <T extends TraceCarrier, V> Function<T, V> contextPropagationMiddleware(Function<T, V> delegate) {
        return t -> {
            try (Scope scope = this.propagateTraceContext((TraceCarrier)t);){
                Object r = delegate.apply(t);
                return r;
            }
        };
    }

    public <T extends TraceCarrier> Consumer<T> contextPropagationMiddleware(Consumer<T> delegate) {
        return t -> {
            try (Scope scope = this.propagateTraceContext((TraceCarrier)t);){
                delegate.accept(t);
            }
        };
    }

    public <T> Supplier<T> contextPropagationMiddleware(Supplier<T> delegate, TraceCarrier traceCarrier) {
        return () -> {
            try (Scope scope = this.propagateTraceContext(traceCarrier);){
                Object t = delegate.get();
                return t;
            }
        };
    }

    private Scope propagateTraceContext(TraceCarrier carrier) {
        Context extractedContext = this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)carrier, (TextMapGetter)new TraceCarrierTextMapGetter());
        return extractedContext.makeCurrent();
    }

    private static class TraceCarrierTextMapGetter
    implements TextMapGetter<TraceCarrier> {
        private TraceCarrierTextMapGetter() {
        }

        public Iterable<String> keys(TraceCarrier carrier) {
            return carrier.getTraceContext().keySet();
        }

        public String get(TraceCarrier carrier, String key) {
            return carrier.getTraceContext().get(key);
        }
    }
}

