/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.monitor;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.edc.runtime.metamodel.annotation.ExtensionPoint;
import org.eclipse.edc.spi.monitor.PrefixMonitor;

@ExtensionPoint
public interface Monitor {
    default public void severe(Supplier<String> supplier, Throwable ... errors) {
    }

    default public void severe(String message, Throwable ... errors) {
        this.severe(() -> message, errors);
    }

    default public void severe(Map<String, Object> data) {
    }

    default public void warning(Supplier<String> supplier, Throwable ... errors) {
    }

    default public void warning(String message, Throwable ... errors) {
        this.warning(() -> message, errors);
    }

    default public void info(Supplier<String> supplier, Throwable ... errors) {
    }

    default public void info(String message, Throwable ... errors) {
        this.info(() -> message, errors);
    }

    default public void debug(Supplier<String> supplier, Throwable ... errors) {
    }

    default public void debug(String message, Throwable ... errors) {
        this.debug(() -> message, errors);
    }

    default public String sanitizeMessage(Supplier<String> supplier) {
        return Optional.ofNullable(supplier.get()).map(msg -> msg.replaceAll("([\\r\\n])", " ")).orElse(null);
    }

    default public Monitor withPrefix(String prefix) {
        return new PrefixMonitor(this, prefix);
    }
}

