/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.edc.connector.dataplane.aws.s3.exceptions.S3DataSourceException;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamFailure;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.util.string.StringUtils;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;

class S3DataSource
implements DataSource {
    private String bucketName;
    @Deprecated(since="0.5.2")
    private String keyName;
    private String objectName;
    @Deprecated(since="0.5.2")
    private String keyPrefix;
    private String objectPrefix;
    private S3Client client;
    private Monitor monitor;
    private final Predicate<S3Object> isFile = object -> !object.key().endsWith("/");

    private S3DataSource() {
    }

    public StreamResult<Stream<DataSource.Part>> openPartStream() {
        if (StringUtils.isNullOrEmpty((String)this.objectPrefix) && !StringUtils.isNullOrEmpty((String)this.keyPrefix)) {
            this.monitor.warning("The usage of the property \"keyPrefix\" to define the object prefix is deprecated since version 0.5.2. Please use the \"objectPrefix\" property instead to store this value for new assets. Additionally, update existing assets to use the \"objectPrefix\" property.", new Throwable[0]);
            this.objectPrefix = this.keyPrefix;
        }
        if (this.objectPrefix != null) {
            List<S3Object> s3Objects = this.fetchPrefixedS3Objects();
            if (s3Objects.isEmpty()) {
                return StreamResult.failure((StreamFailure)new StreamFailure(List.of("Error listing S3 objects in the bucket: Object not found"), StreamFailure.Reason.GENERAL_ERROR));
            }
            Stream<DataSource.Part> s3PartStream = s3Objects.stream().map(S3Object::key).map(key -> new S3Part(this.client, (String)key, this.bucketName));
            return StreamResult.success(s3PartStream);
        }
        if (StringUtils.isNullOrEmpty((String)this.objectName) && !StringUtils.isNullOrEmpty((String)this.keyName)) {
            this.monitor.warning("The usage of the property \"keyName\" to define the object name is deprecated since version 0.5.2. Please use the \"objectName\" property instead to store this value for new assets. Additionally, update existing assets to use the \"objectName\" property.", new Throwable[0]);
            this.objectName = this.keyName;
        }
        return StreamResult.success(Stream.of(new S3Part(this.client, this.objectName, this.bucketName)));
    }

    private List<S3Object> fetchPrefixedS3Objects() {
        ListObjectsV2Response response;
        String continuationToken = null;
        ArrayList<S3Object> s3Objects = new ArrayList<S3Object>();
        do {
            ListObjectsV2Request listObjectsRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName).prefix(this.objectPrefix).continuationToken(continuationToken).build();
            response = this.client.listObjectsV2(listObjectsRequest);
            s3Objects.addAll(response.contents().stream().filter(this.isFile).toList());
        } while ((continuationToken = response.nextContinuationToken()) != null);
        return s3Objects;
    }

    public void close() {
    }

    private static class S3Part
    implements DataSource.Part {
        private final S3Client client;
        private final String objectName;
        private final String bucketName;

        S3Part(S3Client client, String objectName, String bucketName) {
            this.client = client;
            this.objectName = objectName;
            this.bucketName = bucketName;
        }

        public String name() {
            return this.objectName;
        }

        public long size() {
            HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().key(this.objectName).bucket(this.bucketName).build();
            return this.client.headObject(request).contentLength();
        }

        public InputStream openStream() {
            try {
                GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().key(this.objectName).bucket(this.bucketName).build();
                return this.client.getObject(request);
            }
            catch (Exception e) {
                throw new S3DataSourceException(e.getMessage(), e);
            }
        }
    }

    public static class Builder {
        private final S3DataSource source = new S3DataSource();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder bucketName(String bucketName) {
            this.source.bucketName = bucketName;
            return this;
        }

        public Builder keyName(String keyName) {
            this.source.keyName = keyName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.source.objectName = objectName;
            return this;
        }

        public Builder keyPrefix(String keyPrefix) {
            this.source.keyPrefix = keyPrefix;
            return this;
        }

        public Builder objectPrefix(String objectPrefix) {
            this.source.objectPrefix = objectPrefix;
            return this;
        }

        public Builder client(S3Client client) {
            this.source.client = client;
            return this;
        }

        public Builder monitor(Monitor monitor) {
            this.source.monitor = monitor;
            return this;
        }

        public S3DataSource build() {
            return this.source;
        }
    }
}

