/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.edc.aws.s3.AwsClientProvider;
import org.eclipse.edc.connector.dataplane.aws.s3.S3DataSinkFactory;
import org.eclipse.edc.connector.dataplane.aws.s3.S3DataSourceFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.PipelineService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.validator.spi.DataAddressValidatorRegistry;

@Extension(value="Data Plane S3 Storage")
public class DataPlaneS3Extension
implements ServiceExtension {
    public static final String NAME = "Data Plane S3 Storage";
    private static final int DEFAULT_CHUNK_SIZE_IN_MB = 500;
    @Setting(value="The maximum chunk of stream to be read, in mb", defaultValue="500", type="int")
    private static final String EDC_DATAPLANE_S3_SINK_CHUNK_SIZE_MB = "edc.dataplane.aws.sink.chunk.size.mb";
    @Inject
    private PipelineService pipelineService;
    @Inject
    private AwsClientProvider awsClientProvider;
    @Inject
    private Vault vault;
    @Inject
    private TypeManager typeManager;
    @Inject
    private DataAddressValidatorRegistry validator;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        int chunkSizeInMb = context.getSetting(EDC_DATAPLANE_S3_SINK_CHUNK_SIZE_MB, 500);
        int chunkSizeInBytes = 0x100000 * chunkSizeInMb;
        if (chunkSizeInBytes < 1) {
            throw new IllegalArgumentException("Chunk size must be greater than zero! Actual value is: " + chunkSizeInBytes);
        }
        Monitor monitor = context.getMonitor();
        S3DataSourceFactory sourceFactory = new S3DataSourceFactory(this.awsClientProvider, monitor, this.vault, this.typeManager.getMapper(), this.validator);
        this.pipelineService.registerFactory((DataSourceFactory)sourceFactory);
        S3DataSinkFactory sinkFactory = new S3DataSinkFactory(this.awsClientProvider, executorService, monitor, this.vault, this.typeManager.getMapper(), chunkSizeInBytes, this.validator);
        this.pipelineService.registerFactory((DataSinkFactory)sinkFactory);
    }
}

