/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.core.processor.introspection;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.AnnotationFunctions;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.ElementFunctions;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.SettingContext;
import org.eclipse.edc.runtime.metamodel.domain.ConfigurationSetting;
import org.eclipse.edc.runtime.metamodel.domain.Service;
import org.eclipse.edc.runtime.metamodel.domain.ServiceReference;
import org.jetbrains.annotations.NotNull;

public class ExtensionIntrospector {
    private final Elements elementUtils;

    public ExtensionIntrospector(Elements elementUtils) {
        this.elementUtils = elementUtils;
    }

    public List<String> getExtensionCategories(Element extensionElement) {
        AnnotationMirror annotationMirror = AnnotationFunctions.mirrorFor(Extension.class, extensionElement);
        return annotationMirror != null ? AnnotationFunctions.attributeStringValues("categories", annotationMirror, this.elementUtils) : Collections.emptyList();
    }

    public List<ServiceReference> resolveReferencedServices(Element extensionElement) {
        return this.getEnclosedElementsAnnotatedWith(extensionElement, Inject.class).map(element -> {
            Boolean required = AnnotationFunctions.attributeValue(Boolean.class, "required", AnnotationFunctions.mirrorFor(Inject.class, element), this.elementUtils);
            return new ServiceReference(ElementFunctions.typeFor(element), required.booleanValue());
        }).collect(Collectors.toList());
    }

    public List<Service> resolveProvidedServices(Element element) {
        Stream providesServices = Optional.ofNullable(AnnotationFunctions.mirrorFor(Provides.class, element)).map(mirror -> AnnotationFunctions.attributeTypeValues("value", mirror, this.elementUtils).stream()).orElse(Stream.empty());
        Stream<String> providerMethodServices = this.getEnclosedElementsAnnotatedWith(element, Provider.class).map(AnnotationFunctions::mirrorForReturn).filter(Objects::nonNull).map(TypeMirror::toString);
        return Stream.concat(providesServices, providerMethodServices).distinct().map(Service::new).collect(Collectors.toList());
    }

    public List<ConfigurationSetting> resolveConfigurationSettings(Element element) {
        return this.getEnclosedElementsAnnotatedWith(element, Setting.class).filter(VariableElement.class::isInstance).map(VariableElement.class::cast).map(this::createConfigurationSetting).collect(Collectors.toList());
    }

    public String getExtensionName(Element extensionElement) {
        AnnotationMirror annotationMirror = AnnotationFunctions.mirrorFor(Extension.class, extensionElement);
        return annotationMirror != null ? AnnotationFunctions.attributeValue(String.class, "value", annotationMirror, this.elementUtils) : extensionElement.getSimpleName().toString();
    }

    public String getExtensionClassname(Element element) {
        return element.asType().toString();
    }

    private Stream<? extends Element> getEnclosedElementsAnnotatedWith(Element extensionElement, Class<? extends Annotation> annotationClass) {
        return extensionElement.getEnclosedElements().stream().filter(e -> e.getAnnotation(annotationClass) != null);
    }

    private ConfigurationSetting createConfigurationSetting(VariableElement settingElement) {
        String prefix = this.resolveConfigurationPrefix(settingElement);
        String keyValue = prefix + settingElement.getConstantValue().toString();
        ConfigurationSetting.Builder settingBuilder = ConfigurationSetting.Builder.newInstance().key(keyValue);
        AnnotationMirror settingMirror = AnnotationFunctions.mirrorFor(Setting.class, settingElement);
        String description = AnnotationFunctions.attributeValue(String.class, "value", settingMirror, this.elementUtils);
        settingBuilder.description(description);
        String type = AnnotationFunctions.attributeValue(String.class, "type", settingMirror, this.elementUtils);
        settingBuilder.type(type);
        Boolean required = AnnotationFunctions.attributeValue(Boolean.class, "required", settingMirror, this.elementUtils);
        settingBuilder.required(required.booleanValue());
        Long max = AnnotationFunctions.attributeValue(Long.class, "max", settingMirror, this.elementUtils);
        settingBuilder.maximum(max);
        Long min = AnnotationFunctions.attributeValue(Long.class, "min", settingMirror, this.elementUtils);
        settingBuilder.minimum(min);
        return settingBuilder.build();
    }

    @NotNull
    private String resolveConfigurationPrefix(VariableElement edcSettingElement) {
        Element enclosingElement = edcSettingElement.getEnclosingElement();
        if (enclosingElement == null) {
            return "";
        }
        AnnotationMirror contextMirror = AnnotationFunctions.mirrorFor(SettingContext.class, enclosingElement);
        return contextMirror != null ? AnnotationFunctions.attributeValue(String.class, "value", contextMirror, this.elementUtils) : "";
    }
}

