/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.core.processor.introspection;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import org.eclipse.edc.plugins.autodoc.core.processor.generator.JavadocConverter;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Spi;
import org.eclipse.edc.runtime.metamodel.domain.ModuleType;
import org.jetbrains.annotations.Nullable;

public class OverviewIntrospector {
    private final JavadocConverter javadocConverter;
    private final Elements elementUtils;

    public OverviewIntrospector(@Nullable JavadocConverter javadocConverter, Elements elementUtils) {
        this.javadocConverter = javadocConverter;
        this.elementUtils = elementUtils;
    }

    @Nullable
    public String generateModuleOverview(ModuleType moduleType, RoundEnvironment environment) {
        Class annotation = moduleType == ModuleType.EXTENSION ? Extension.class : Spi.class;
        Set<? extends Element> elements = environment.getElementsAnnotatedWith(annotation);
        if (elements.isEmpty()) {
            return null;
        }
        Element moduleElement = elements.iterator().next();
        String javadoc = this.elementUtils.getDocComment(moduleElement);
        if (javadoc == null) {
            return "No overview provided.";
        }
        return this.javadocConverter != null ? this.javadocConverter.generate(javadoc) : "No JavadocConverter available";
    }
}

