/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.core.processor.introspection;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.AnnotationFunctions;
import org.eclipse.edc.runtime.metamodel.annotation.Configuration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.ExtensionPoint;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Requires;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.Settings;
import org.eclipse.edc.runtime.metamodel.annotation.Spi;
import org.eclipse.edc.runtime.metamodel.domain.Service;

public class ModuleIntrospector {
    private static final String SERVICE_EXTENSION_NAME = "org.eclipse.edc.spi.system.ServiceExtension";
    private static final String SYSTEM_EXTENSION_NAME = "org.eclipse.edc.spi.system.SystemExtension";
    private final Elements elementUtils;
    private final Types typeUtils;
    private final ProcessingEnvironment processingEnv;

    public ModuleIntrospector(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    public List<String> getCategories(RoundEnvironment environment) {
        Element extensionElement = environment.getElementsAnnotatedWith(Spi.class).iterator().next();
        return AnnotationFunctions.attributeStringValues("categories", AnnotationFunctions.mirrorFor(Spi.class, extensionElement), this.elementUtils);
    }

    public List<Service> resolveExtensionPoints(RoundEnvironment environment) {
        return environment.getElementsAnnotatedWith(ExtensionPoint.class).stream().map(element -> new Service(element.asType().toString())).collect(Collectors.toList());
    }

    public String getModuleName(RoundEnvironment environment) {
        Element extensionElement = environment.getElementsAnnotatedWith(Spi.class).iterator().next();
        return AnnotationFunctions.attributeValue(String.class, "value", AnnotationFunctions.mirrorFor(Spi.class, extensionElement), this.elementUtils);
    }

    public Set<Element> getExtensionElements(RoundEnvironment environment) {
        Stream<Element> settingsSymbols = environment.getElementsAnnotatedWith(Setting.class).stream().peek(setting -> {
            TypeMirror serviceExtensionType = this.typeUtils.erasure(this.elementUtils.getTypeElement(SYSTEM_EXTENSION_NAME).asType());
            TypeMirror enclosingElement = setting.getEnclosingElement().asType();
            if (!this.typeUtils.isAssignable(enclosingElement, serviceExtensionType) && setting.getEnclosingElement().getAnnotation(Settings.class) == null) {
                String message = "@Setting annotation must be used inside a ServiceExtension implementation or a type annotated with @Settings, the " + "ones defined in %s will be excluded from the autodoc manifest".formatted(enclosingElement);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, (Element)setting);
            }
        });
        environment.getElementsAnnotatedWith(Configuration.class).forEach(setting -> {
            TypeMirror serviceExtensionType = this.typeUtils.erasure(this.elementUtils.getTypeElement(SYSTEM_EXTENSION_NAME).asType());
            TypeMirror enclosingElement = setting.getEnclosingElement().asType();
            if (!this.typeUtils.isAssignable(enclosingElement, serviceExtensionType)) {
                String message = "@Configuration annotations must be used inside a ServiceExtension implementation, the " + "ones defined in %s will be excluded from the autodoc manifest".formatted(enclosingElement);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, (Element)setting);
            }
        });
        Set<? extends Element> injectSymbols = environment.getElementsAnnotatedWith(Inject.class);
        Set<? extends Element> providerSymbols = environment.getElementsAnnotatedWith(Provider.class);
        Set<Element> classes = Stream.of(settingsSymbols, injectSymbols.stream(), providerSymbols.stream()).reduce(Stream::concat).orElse(Stream.empty()).map(Element::getEnclosingElement).filter(this::isExtension).collect(Collectors.toSet());
        classes.addAll(environment.getElementsAnnotatedWith(Requires.class));
        classes.addAll(environment.getElementsAnnotatedWith(Provides.class));
        classes.addAll(environment.getElementsAnnotatedWith(Extension.class));
        return classes;
    }

    private boolean isExtension(Element element) {
        TypeElement t = (TypeElement)element;
        while (t != null && !t.toString().equals(Object.class.getName())) {
            if (t.getInterfaces().stream().anyMatch(p -> p.toString().contains(SERVICE_EXTENSION_NAME))) {
                return true;
            }
            t = (TypeElement)this.typeUtils.asElement(t.getSuperclass());
        }
        return false;
    }
}

