/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.core.processor.introspection;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.AnnotationFunctions;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.ElementFunctions;
import org.eclipse.edc.runtime.metamodel.annotation.Configuration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.SettingContext;
import org.eclipse.edc.runtime.metamodel.domain.ConfigurationSetting;
import org.eclipse.edc.runtime.metamodel.domain.Service;
import org.eclipse.edc.runtime.metamodel.domain.ServiceReference;
import org.jetbrains.annotations.NotNull;

public class ExtensionIntrospector {
    public static final String CONTEXT_ATTRIBUTE = "context";
    private final Elements elementUtils;
    private final Types typeUtils;

    public ExtensionIntrospector(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    public List<String> getExtensionCategories(Element extensionElement) {
        AnnotationMirror annotationMirror = AnnotationFunctions.mirrorFor(Extension.class, extensionElement);
        return annotationMirror != null ? AnnotationFunctions.attributeStringValues("categories", annotationMirror, this.elementUtils) : Collections.emptyList();
    }

    public List<ServiceReference> resolveReferencedServices(Element extensionElement) {
        return this.getEnclosedElementsAnnotatedWith(extensionElement, Inject.class).map(element -> {
            Boolean required = AnnotationFunctions.attributeValue(Boolean.class, "required", AnnotationFunctions.mirrorFor(Inject.class, element), this.elementUtils);
            return new ServiceReference(ElementFunctions.typeFor(element), required.booleanValue());
        }).collect(Collectors.toList());
    }

    public List<Service> resolveProvidedServices(Element element) {
        Stream providesServices = Optional.ofNullable(AnnotationFunctions.mirrorFor(Provides.class, element)).map(mirror -> AnnotationFunctions.attributeTypeValues("value", mirror, this.elementUtils).stream()).orElse(Stream.empty());
        Stream<String> providerMethodServices = this.getEnclosedElementsAnnotatedWith(element, Provider.class).map(AnnotationFunctions::mirrorForReturn).filter(Objects::nonNull).map(TypeMirror::toString);
        return Stream.concat(providesServices, providerMethodServices).distinct().map(Service::new).collect(Collectors.toList());
    }

    public List<ConfigurationSetting> resolveConfigurationSettings(Element element) {
        Stream settingsInConfigObjects = this.getEnclosedElementsAnnotatedWith(element, Configuration.class).flatMap(e -> this.getEnclosedElementsAnnotatedWith(this.typeUtils.asElement(e.asType()), Setting.class));
        return Stream.concat(settingsInConfigObjects, this.getEnclosedElementsAnnotatedWith(element, Setting.class)).filter(VariableElement.class::isInstance).map(VariableElement.class::cast).map(this::createConfigurationSetting).collect(Collectors.toList());
    }

    public String getExtensionName(Element extensionElement) {
        AnnotationMirror annotationMirror = AnnotationFunctions.mirrorFor(Extension.class, extensionElement);
        return annotationMirror != null ? AnnotationFunctions.attributeValue(String.class, "value", annotationMirror, this.elementUtils) : extensionElement.getSimpleName().toString();
    }

    public String getExtensionClassname(Element element) {
        return element.asType().toString();
    }

    private Stream<? extends Element> getEnclosedElementsAnnotatedWith(Element extensionElement, Class<? extends Annotation> annotationClass) {
        return extensionElement.getEnclosedElements().stream().filter(e -> e.getAnnotation(annotationClass) != null);
    }

    private ConfigurationSetting createConfigurationSetting(VariableElement settingElement) {
        AnnotationMirror settingMirror = AnnotationFunctions.mirrorFor(Setting.class, settingElement);
        String prefix = AnnotationFunctions.attributeValue(String.class, CONTEXT_ATTRIBUTE, settingMirror, this.elementUtils);
        if (prefix.isEmpty()) {
            prefix = this.resolveConfigurationPrefix(settingElement);
        }
        String keyValue = prefix + Optional.ofNullable(settingElement.getConstantValue()).orElseGet(() -> AnnotationFunctions.attributeValue(String.class, "key", settingMirror, this.elementUtils)).toString();
        String description = Stream.of(AnnotationFunctions.attributeValue(String.class, "description", settingMirror, this.elementUtils), AnnotationFunctions.attributeValue(String.class, "value", settingMirror, this.elementUtils)).filter(Objects::nonNull).filter(it -> !it.isEmpty()).findFirst().orElse(null);
        return ConfigurationSetting.Builder.newInstance().key(keyValue).description(description).type(AnnotationFunctions.attributeValue(String.class, "type", settingMirror, this.elementUtils)).required(AnnotationFunctions.attributeValue(Boolean.class, "required", settingMirror, this.elementUtils).booleanValue()).maximum(AnnotationFunctions.attributeValue(Long.class, "max", settingMirror, this.elementUtils)).minimum(AnnotationFunctions.attributeValue(Long.class, "min", settingMirror, this.elementUtils)).defaultValue(AnnotationFunctions.attributeValue(String.class, "defaultValue", settingMirror, this.elementUtils)).deprecated(AnnotationFunctions.mirrorFor(Deprecated.class, settingElement) != null).build();
    }

    @NotNull
    private String resolveConfigurationPrefix(VariableElement edcSettingElement) {
        Element enclosingElement = edcSettingElement.getEnclosingElement();
        if (enclosingElement == null) {
            return "";
        }
        AnnotationMirror contextMirror = AnnotationFunctions.mirrorFor(SettingContext.class, enclosingElement);
        return contextMirror != null ? AnnotationFunctions.attributeValue(String.class, "value", contextMirror, this.elementUtils) : "";
    }
}

