/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.core.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.edc.plugins.autodoc.core.processor.introspection.ExtensionIntrospector;
import org.eclipse.edc.plugins.autodoc.core.processor.introspection.ModuleIntrospector;
import org.eclipse.edc.plugins.autodoc.core.processor.introspection.OverviewIntrospector;
import org.eclipse.edc.runtime.metamodel.annotation.Spi;
import org.eclipse.edc.runtime.metamodel.domain.EdcModule;
import org.eclipse.edc.runtime.metamodel.domain.EdcServiceExtension;
import org.eclipse.edc.runtime.metamodel.domain.ModuleType;
import org.jetbrains.annotations.Nullable;

@SupportedAnnotationTypes(value={"org.eclipse.edc.runtime.metamodel.annotation.Setting", "org.eclipse.edc.runtime.metamodel.annotation.SettingContext", "org.eclipse.edc.runtime.metamodel.annotation.Extension", "org.eclipse.edc.runtime.metamodel.annotation.Spi", "org.eclipse.edc.runtime.metamodel.annotation.ExtensionPoint", "org.eclipse.edc.runtime.metamodel.annotation.Provider", "org.eclipse.edc.runtime.metamodel.annotation.Provides", "org.eclipse.edc.runtime.metamodel.annotation.Requires", "org.eclipse.edc.runtime.metamodel.annotation.Inject"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"edc.id", "edc.version", "edc.outputDir"})
public class EdcModuleProcessor
extends AbstractProcessor {
    public static final String VERSION = "edc.version";
    public static final String ID = "edc.id";
    public static final String EDC_OUTPUTDIR_OVERRIDE = "edc.outputDir";
    private static final String MANIFEST_NAME = "edc.json";
    private final ObjectMapper mapper = new ObjectMapper();
    private ModuleIntrospector moduleIntrospector;
    private OverviewIntrospector overviewIntrospector;
    private EdcModule.Builder moduleBuilder;
    private EdcServiceExtension.Builder extensionBuilder;
    private ExtensionIntrospector extensionIntrospector;
    private ModuleType moduleType;
    private Set<Element> extensionElements;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.moduleIntrospector = new ModuleIntrospector(processingEnv);
        this.overviewIntrospector = new OverviewIntrospector(javadoc -> javadoc, processingEnv.getElementUtils());
        this.extensionIntrospector = new ExtensionIntrospector(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment environment) {
        boolean result;
        if (this.moduleBuilder == null && !(result = this.initializeModuleBuilder(environment))) {
            return false;
        }
        if (environment.processingOver()) {
            if (this.moduleBuilder != null) {
                this.writeManifest();
            }
            return false;
        }
        if (this.moduleType == ModuleType.EXTENSION) {
            this.extensionElements.forEach(element -> {
                this.extensionBuilder = EdcServiceExtension.Builder.newInstance().type(this.moduleType).name(this.extensionIntrospector.getExtensionName((Element)element)).className(this.extensionIntrospector.getExtensionClassname((Element)element)).provides(this.extensionIntrospector.resolveProvidedServices((Element)element)).references(this.extensionIntrospector.resolveReferencedServices((Element)element)).configuration(this.extensionIntrospector.resolveConfigurationSettings((Element)element)).overview(this.overviewIntrospector.generateModuleOverview(this.moduleType, environment)).categories(this.extensionIntrospector.getExtensionCategories((Element)element));
                this.moduleBuilder.extension(this.extensionBuilder.build());
            });
        } else {
            this.moduleBuilder.name(this.moduleIntrospector.getModuleName(environment));
            this.moduleBuilder.categories(this.moduleIntrospector.getCategories(environment));
        }
        this.moduleBuilder.extensionPoints(this.moduleIntrospector.resolveExtensionPoints(environment));
        return false;
    }

    private boolean initializeModuleBuilder(RoundEnvironment environment) {
        String id = this.processingEnv.getOptions().get(ID);
        if (id == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Value for 'edc.id' not set on processor configuration. Skipping manifest generation.");
            return false;
        }
        String version = this.processingEnv.getOptions().get(VERSION);
        if (version == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Value for 'edc.version' not set on processor configuration. Skipping manifest generation.");
            return false;
        }
        this.extensionElements = this.moduleIntrospector.getExtensionElements(environment);
        this.moduleType = this.determineAndValidateModuleType(environment, this.extensionElements);
        if (this.moduleType == ModuleType.INVALID) {
            return false;
        }
        this.moduleBuilder = EdcModule.Builder.newInstance().modulePath(id).version(version);
        return true;
    }

    @Nullable
    private ModuleType determineAndValidateModuleType(RoundEnvironment environment, Set<Element> extensionElements) {
        if (extensionElements.isEmpty()) {
            Set<? extends Element> spiElements = environment.getElementsAnnotatedWith(Spi.class);
            if (spiElements.size() > 1) {
                String types = spiElements.stream().map(e -> e.asType().toString()).collect(Collectors.joining(", "));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Multiple SPI definitions found in module: " + types);
                return ModuleType.INVALID;
            }
            if (spiElements.isEmpty()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Not an EDC module. Skipping module processing.");
                return ModuleType.INVALID;
            }
            return ModuleType.SPI;
        }
        return ModuleType.EXTENSION;
    }

    private void writeManifest() {
        block14: {
            try {
                Filer filer = this.processingEnv.getFiler();
                String location = this.processingEnv.getOptions().get(EDC_OUTPUTDIR_OVERRIDE);
                if (location != null) {
                    new File(location).mkdirs();
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(location + File.separator + MANIFEST_NAME));){
                        this.mapper.writeValue((Writer)writer, List.of(this.moduleBuilder.build()));
                        break block14;
                    }
                }
                FileObject resource = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", MANIFEST_NAME, new Element[0]);
                try (Writer writer = resource.openWriter();){
                    this.mapper.writeValue(writer, List.of(this.moduleBuilder.build()));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

