/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.edc.plugins.autodoc.AutodocExtension;
import org.eclipse.edc.plugins.autodoc.tasks.JsonFileAppender;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.internal.GFileUtils;

public class MergeManifestsTask
extends DefaultTask {
    public static final String NAME = "mergeManifests";
    private static final String MERGED_MANIFEST_FILENAME = "manifest.json";
    private final JsonFileAppender appender = new JsonFileAppender(this.getProject().getLogger());
    private File destinationFile;

    public MergeManifestsTask() {
        String rootProjectPath = ((File)this.getProject().getRootProject().getLayout().getBuildDirectory().getAsFile().get()).getAbsolutePath();
        this.destinationFile = Path.of(rootProjectPath, MERGED_MANIFEST_FILENAME).toFile();
    }

    @TaskAction
    public void mergeManifests() {
        AutodocExtension autodocExt = (AutodocExtension)this.getProject().getExtensions().findByType(AutodocExtension.class);
        Objects.requireNonNull(autodocExt, "AutodocExtension cannot be null");
        File destination = this.getDestinationFile();
        if (destination == null) {
            throw new GradleException("destinationFile must be configured but was null!");
        }
        Provider projectBuildDirectory = this.getProject().getLayout().getBuildDirectory().getAsFile();
        File sourceFile = Path.of(((File)autodocExt.getOutputDirectory().convention(projectBuildDirectory).get()).getAbsolutePath(), "edc.json").toFile();
        if (sourceFile.exists()) {
            this.appender.append(destination, sourceFile);
        } else {
            this.getProject().getLogger().lifecycle("Skip project [{}] - no manifest file found", new Object[]{sourceFile});
        }
        if (autodocExt.getAdditionalInputDirectory().isPresent() && ((File)autodocExt.getAdditionalInputDirectory().get()).exists() && this.getProject().equals(this.getProject().getRootProject()) && autodocExt.isIncludeTransitive()) {
            File dir = (File)autodocExt.getAdditionalInputDirectory().get();
            Collection files = GFileUtils.listFiles((File)dir, (String[])new String[]{"json"}, (boolean)false);
            this.getLogger().lifecycle("Appending [{}] additional JSON files to the merged manifest", new Object[]{files.size()});
            files.forEach(f -> this.appender.append(destination, (File)f));
        }
    }

    @OutputFile
    public File getDestinationFile() {
        return this.destinationFile;
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile = destinationFile;
    }
}

