/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;

class JsonFileAppender {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private final Logger logger;
    private final ObjectMapper mapper;
    private final TypeReference<List<?>> listTypeReference;

    JsonFileAppender(Logger logger) {
        this.logger = logger;
        this.mapper = new ObjectMapper();
        this.listTypeReference = new TypeReference<List<?>>(){};
    }

    public void append(File destination, File source) {
        this.logger.lifecycle(String.format("Appending contents of [%s] to [%s]", source, destination));
        this.checkOrCreate(destination);
        if (!source.exists()) {
            throw new GradleException(String.format("Source file [%s] does not exist!", source));
        }
        LOCK.lock();
        try {
            List<?> srcContent = this.readJsonFile(source);
            List<?> targetContent = this.readJsonFile(destination);
            ArrayList newContent = new ArrayList();
            newContent.addAll(targetContent);
            newContent.addAll(srcContent);
            this.writeJsonFile(newContent, destination);
        }
        catch (IOException e) {
            throw new GradleException("Error reading input manifest", (Throwable)e);
        }
        finally {
            LOCK.unlock();
        }
    }

    private void writeJsonFile(List<?> content, File destination) throws IOException {
        this.mapper.writeValue(destination, content);
    }

    private List<?> readJsonFile(File source) throws IOException {
        try {
            return (List)this.mapper.readValue(source, this.listTypeReference);
        }
        catch (IOException ex) {
            return Collections.emptyList();
        }
    }

    private void checkOrCreate(File destination) {
        if (!destination.exists()) {
            this.logger.warn("Destination file {} does not exist, creating...", (Object)destination);
            try {
                if (!destination.createNewFile()) {
                    this.destinationError(destination, null);
                }
            }
            catch (IOException e) {
                this.destinationError(destination, e);
            }
        }
    }

    private void destinationError(File destination, Throwable t) {
        this.logger.error("Could not create destination file {}", (Object)destination);
        throw new GradleException("Error creating destination file", t);
    }
}

