/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc;

import java.util.List;
import org.eclipse.edc.plugins.autodoc.AutodocExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;

class AutodocDependencyInjector
implements DependencyResolutionListener {
    private static final String ANNOTATION_PROCESSOR = "annotationProcessor";
    private static final String VERSION = "edc.version";
    private static final String ID = "edc.id";
    private static final String OUTPUTDIR = "edc.outputDir";
    private static final String DEPENDENCY_NAME = String.format("%s:%s", "org.eclipse.edc", "autodoc-processor");
    private final Project project;
    private final AutodocExtension extension;

    AutodocDependencyInjector(Project project, AutodocExtension extension) {
        this.project = project;
        this.extension = extension;
    }

    public void beforeResolve(ResolvableDependencies dependencies) {
        Task task;
        String artifact = DEPENDENCY_NAME + ":" + this.getProcessorVersion();
        if (this.addDependency(this.project, artifact) && (task = (Task)this.project.getTasks().findByName("compileJava")) instanceof JavaCompile) {
            JavaCompile compileJava = (JavaCompile)task;
            String versionArg = String.format("-A%s=%s", VERSION, this.project.getVersion());
            String idArg = String.format("-A%s=%s:%s", ID, this.project.getGroup(), this.project.getName());
            Provider projectBuildDirectory = this.project.getLayout().getBuildDirectory().getAsFile();
            String outputArg = String.format("-A%s=%s", OUTPUTDIR, this.extension.getOutputDirectory().convention(projectBuildDirectory).get());
            compileJava.getOptions().getCompilerArgs().addAll(List.of(idArg, versionArg, outputArg));
        }
        this.project.getGradle().removeListener((Object)this);
    }

    public void afterResolve(ResolvableDependencies dependencies) {
    }

    @NotNull
    private String getProcessorVersion() {
        Property<String> processorVersion = this.extension.getProcessorVersion();
        if (processorVersion.isPresent()) {
            String version = (String)processorVersion.get();
            this.project.getLogger().debug("{}: use configured version from AutodocExtension (override) [{}]", (Object)this.project.getName(), (Object)version);
            return version;
        }
        String version = this.project.getVersion().toString();
        this.project.getLogger().info("No explicit configuration value for the annotationProcessor version was found. Project version {} will be used", (Object)version);
        return version;
    }

    private boolean addDependency(Project project, String dependencyName) {
        Configuration apConfig = (Configuration)project.getConfigurations().findByName(ANNOTATION_PROCESSOR);
        if (apConfig != null) {
            project.getLogger().debug("autodoc: Add dependency {}(\"{}\") to project {}", new Object[]{ANNOTATION_PROCESSOR, dependencyName, project.getName()});
            return apConfig.getDependencies().add((Object)project.getDependencies().create((Object)dependencyName));
        }
        return false;
    }
}

