/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.Function;
import org.eclipse.edc.plugins.autodoc.html.HtmlManifestRenderer;
import org.eclipse.edc.plugins.autodoc.json.JsonManifestReader;
import org.eclipse.edc.plugins.autodoc.markdown.MarkdownManifestRenderer;
import org.eclipse.edc.plugins.autodoc.spi.ManifestRenderer;
import org.eclipse.edc.plugins.autodoc.spi.ManifestWriter;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class MarkdownRendererTask
extends DefaultTask {
    private final JsonManifestReader reader = new JsonManifestReader(new ObjectMapper());
    private final Function<OutputStream, ManifestRenderer> manifestRendererSupplier;
    private final String fileExtension;

    public MarkdownRendererTask(Function<OutputStream, ManifestRenderer> manifestRendererSupplier, String fileExtension) {
        this.manifestRendererSupplier = manifestRendererSupplier;
        this.fileExtension = fileExtension;
    }

    @TaskAction
    public void renderMarkdown() {
        File buildDir = (File)this.getProject().getLayout().getBuildDirectory().getAsFile().get();
        File manifest = this.getProject().getRootProject().equals(this.getProject()) ? Path.of(buildDir.getAbsolutePath(), "manifest.json").toFile() : Path.of(buildDir.getAbsolutePath(), "edc.json").toFile();
        if (manifest.exists()) {
            File outputFile = new File(buildDir, this.getProject().getName() + "." + this.fileExtension);
            try (FileOutputStream fos = new FileOutputStream(outputFile);
                 FileInputStream fis = new FileInputStream(manifest);){
                ManifestWriter writer = new ManifestWriter(this.manifestRendererSupplier.apply(fos));
                this.getLogger().lifecycle(String.format("Rendering %s for input %s", outputFile, manifest));
                try (OutputStream os = writer.convert(this.reader.read((InputStream)fis));){
                    os.flush();
                }
            }
            catch (IOException e) {
                throw new GradleException("Error rendering Markdown", (Throwable)e);
            }
        }
    }

    public static class ToMarkdown
    extends MarkdownRendererTask {
        public static final String NAME = "doc2md";

        public ToMarkdown() {
            super(MarkdownManifestRenderer::new, "md");
        }
    }

    public static class ToHtml
    extends MarkdownRendererTask {
        public static final String NAME = "doc2html";

        public ToHtml() {
            super(HtmlManifestRenderer::new, "html");
        }
    }
}

