/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.eclipse.edc.plugins.autodoc.json.JsonManifestReader;
import org.eclipse.edc.plugins.autodoc.markdown.MarkdownManifestRenderer;
import org.eclipse.edc.plugins.autodoc.spi.ManifestRenderer;
import org.eclipse.edc.plugins.autodoc.spi.ManifestWriter;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class MarkdownRendererTask
extends DefaultTask {
    public static final String NAME = "doc2md";
    private final JsonManifestReader reader = new JsonManifestReader(new ObjectMapper());

    @TaskAction
    public void renderMarkdown() {
        File buildDir = this.getProject().getBuildDir();
        File manifest = this.getProject().getRootProject().equals(this.getProject()) ? Path.of(buildDir.getAbsolutePath(), "manifest.json").toFile() : Path.of(buildDir.getAbsolutePath(), "edc.json").toFile();
        if (manifest.exists()) {
            File outputFile = new File(this.getProject().getBuildDir(), this.getProject().getName() + ".md");
            try (FileOutputStream fos = new FileOutputStream(outputFile);
                 FileInputStream fis = new FileInputStream(manifest);){
                ManifestWriter writer = new ManifestWriter((ManifestRenderer)new MarkdownManifestRenderer((OutputStream)fos));
                this.getLogger().lifecycle(String.format("Rendering %s for input %s", outputFile, manifest));
                try (OutputStream os = writer.convert(this.reader.read((InputStream)fis));){
                    os.flush();
                }
            }
            catch (IOException e) {
                throw new GradleException("Error rendering Markdown", (Throwable)e);
            }
        }
    }
}

