/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.edc.plugins.autodoc.AutodocExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.tasks.TaskAction;

public class ManifestDownloadTask
extends DefaultTask {
    public static final String NAME = "downloadManifests";
    private static final String EDC_GROUP = "org.eclipse.edc";
    private static final Duration MAX_MANIFEST_AGE = Duration.ofHours(24L);
    private static final String MANIFEST_CLASSIFIER = "manifest";
    private static final String MANIFEST_TYPE = "json";
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private Path downloadDirectory = this.getProject().getRootProject().getBuildDir().toPath().resolve("manifests");

    @TaskAction
    public void downloadManifests() {
        AutodocExtension autodocExt = (AutodocExtension)this.getProject().getExtensions().findByType(AutodocExtension.class);
        Objects.requireNonNull(autodocExt, "AutodocExtension cannot be null");
        if (autodocExt.getDownloadDirectory().isPresent()) {
            this.downloadDirectory = ((File)autodocExt.getDownloadDirectory().get()).toPath();
        }
        this.getProject().getConfigurations().stream().flatMap(config -> config.getDependencies().stream()).filter(dep -> EDC_GROUP.equals(dep.getGroup())).filter(dep -> !this.getExclusions().contains(dep.getName())).map(this::createDownloadRequest).filter(Optional::isPresent).forEach(dt -> this.downloadDependency((DependencyDownload)dt.get(), this.downloadDirectory));
    }

    private String createArtifactUrl(Dependency dep, MavenArtifactRepository repo) {
        return String.format("%s%s/%s/%s/%s-%s-%s.%s", repo.getUrl(), dep.getGroup().replace(".", "/"), dep.getName(), dep.getVersion(), dep.getName(), dep.getVersion(), MANIFEST_CLASSIFIER, MANIFEST_TYPE);
    }

    private void downloadDependency(DependencyDownload dt, Path outputDirectory) {
        Path p = outputDirectory.resolve(dt.filename());
        HttpRequest request = HttpRequest.newBuilder().uri(dt.uri()).GET().build();
        try {
            HttpResponse<InputStream> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                this.getLogger().warn("Could not download {}, HTTP response: {}", (Object)dt.dependency, response);
                return;
            }
            outputDirectory.toFile().mkdirs();
            this.getLogger().debug("Downloading {} into {}", (Object)dt, (Object)outputDirectory);
            try (InputStream is = response.body();
                 FileOutputStream fos = new FileOutputStream(p.toFile());){
                is.transferTo(fos);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<DependencyDownload> createDownloadRequest(Dependency dep) {
        if (this.isLocalFileValid(dep)) {
            this.getLogger().debug("Local file {} was deemed to be viable, will not download", (Object)new DependencyDownload(dep, null, MANIFEST_CLASSIFIER, MANIFEST_TYPE).filename());
            return Optional.empty();
        }
        List repos = this.getProject().getRepositories().stream().toList();
        return repos.stream().filter(repo -> repo instanceof MavenArtifactRepository).map(repo -> (MavenArtifactRepository)repo).map(repo -> {
            String repoUrl = this.createArtifactUrl(dep, (MavenArtifactRepository)repo);
            try {
                URI uri = URI.create(repoUrl);
                HttpRequest headRequest = HttpRequest.newBuilder().uri(uri).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
                HttpResponse<Void> response = this.httpClient.send(headRequest, HttpResponse.BodyHandlers.discarding());
                if (response.statusCode() == 200) {
                    return new DependencyDownload(dep, uri, MANIFEST_CLASSIFIER, MANIFEST_TYPE);
                }
                return null;
            }
            catch (IOException | IllegalArgumentException | InterruptedException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst();
    }

    private boolean isLocalFileValid(Dependency dep) {
        if (!this.downloadDirectory.toFile().exists()) {
            return false;
        }
        Path filePath = this.downloadDirectory.resolve(new DependencyDownload(dep, null, MANIFEST_CLASSIFIER, MANIFEST_TYPE).filename());
        File file = filePath.toFile();
        if (!file.exists() || !file.canRead()) {
            return false;
        }
        try {
            Instant date = Files.getLastModifiedTime(filePath, new LinkOption[0]).toInstant();
            return Duration.between(date, Instant.now()).compareTo(MAX_MANIFEST_AGE) <= 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> getExclusions() {
        return Set.of();
    }

    private record DependencyDownload(Dependency dependency, URI uri, String classifier, String type) {
        @Override
        public String toString() {
            return "{dependency=" + this.dependency + ", uri=" + this.uri + "}";
        }

        String filename() {
            return String.format("%s-%s-%s.%s", this.dependency.getName(), this.dependency.getVersion(), this.classifier, this.type);
        }
    }
}

