/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.edc.plugins.autodoc.AutodocExtension;
import org.eclipse.edc.plugins.autodoc.tasks.JsonFileAppender;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.util.internal.GFileUtils;

public abstract class MergeManifestsTask
extends DefaultTask {
    public static final String NAME = "mergeManifests";
    private static final String MERGED_MANIFEST_FILENAME = "manifest.json";
    private final JsonFileAppender appender = new JsonFileAppender(this.getProject().getLogger());
    private final File projectBuildDirectory = (File)this.getProject().getLayout().getBuildDirectory().getAsFile().get();
    private File destinationFile = ((Directory)this.getProject().getRootProject().getLayout().getBuildDirectory().get()).getAsFile().toPath().resolve("manifest.json").toFile();
    private File inputDirectory = this.projectBuildDirectory.toPath().resolve("autodoc").toFile();
    private String outputDirectoryOption;

    @OutputFile
    public File getDestinationFile() {
        return this.destinationFile;
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile = destinationFile;
    }

    @TaskAction
    public void mergeManifests() {
        File destination;
        if (this.outputDirectoryOption != null) {
            File customOutputDir = new File(this.outputDirectoryOption);
            customOutputDir.mkdirs();
            destination = new File(customOutputDir, MERGED_MANIFEST_FILENAME);
        } else {
            destination = this.destinationFile;
        }
        AutodocExtension autodocExt = (AutodocExtension)this.getProject().getExtensions().findByType(AutodocExtension.class);
        Objects.requireNonNull(autodocExt, "AutodocExtension cannot be null");
        if (destination == null) {
            throw new GradleException("destinationFile must be configured but was null!");
        }
        File sourceFile = Path.of(((File)autodocExt.getOutputDirectory().convention((Object)this.projectBuildDirectory).get()).getAbsolutePath(), "edc.json").toFile();
        if (sourceFile.exists()) {
            this.appender.append(destination, sourceFile);
        } else {
            this.getProject().getLogger().lifecycle("Skip project [{}] - no manifest file found", new Object[]{sourceFile});
        }
        if (this.inputDirectory != null && this.inputDirectory.exists() && autodocExt.isIncludeTransitive()) {
            Collection files = GFileUtils.listFiles((File)this.inputDirectory, (String[])new String[]{"json"}, (boolean)false);
            this.getLogger().lifecycle("Appending [{}] additional JSON files from the inputDirectory to the merged manifest", new Object[]{files.size()});
            files.forEach(f -> this.appender.append(destination, (File)f));
        }
        if (autodocExt.getAdditionalInputDirectory().isPresent() && ((File)autodocExt.getAdditionalInputDirectory().get()).exists() && this.getProject().equals(this.getProject().getRootProject()) && autodocExt.isIncludeTransitive()) {
            File dir = (File)autodocExt.getAdditionalInputDirectory().get();
            Collection files = GFileUtils.listFiles((File)dir, (String[])new String[]{"json"}, (boolean)false);
            this.getLogger().lifecycle("Appending [{}] additional JSON files to the merged manifest", new Object[]{files.size()});
            files.forEach(f -> this.appender.append(destination, (File)f));
        }
    }

    @Option(option="input", description="Directory where previously downloaded or resolved manifest files reside")
    public void setInputDirectory(String inputDirectory) {
        this.inputDirectory = new File(inputDirectory);
    }

    @Option(option="output", description="Directory where the merged manifest should be stored")
    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectoryOption = outputDirectory;
    }
}

