/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.eclipse.edc.plugins.autodoc.tasks.DependencySource;
import org.gradle.api.artifacts.Dependency;

public class HttpSource
extends DependencySource {
    private final HttpClient httpClient = HttpClient.newHttpClient();

    public HttpSource(Dependency dependency, URI uri, String classifier, String type) {
        super(dependency, uri, classifier, type);
    }

    @Override
    public boolean exists() {
        HttpRequest headRequest = HttpRequest.newBuilder().uri(this.uri()).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
        try {
            HttpResponse<Void> response = this.httpClient.send(headRequest, HttpResponse.BodyHandlers.discarding());
            return response.statusCode() == 200;
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream inputStream() {
        HttpResponse<InputStream> response;
        HttpRequest request = HttpRequest.newBuilder().uri(this.uri()).GET().build();
        try {
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (response.statusCode() == 200) {
            return response.body();
        }
        return null;
    }
}

