/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.edc.plugins.autodoc.tasks.AbstractManifestResolveTask;
import org.eclipse.edc.plugins.autodoc.tasks.DependencySource;
import org.eclipse.edc.plugins.autodoc.tasks.DependencySourceFactory;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;

public class DownloadManifestTask
extends AbstractManifestResolveTask {
    public static final String NAME = "downloadManifests";
    private static final Duration MAX_MANIFEST_AGE = Duration.ofHours(24L);

    @Override
    protected boolean includeDependency(Dependency dependency) {
        return !(dependency instanceof ProjectDependency);
    }

    @Override
    protected InputStream resolveManifest(DependencySource autodocManifest) {
        InputStream inputStream = autodocManifest.inputStream();
        if (inputStream == null) {
            this.getLogger().warn("Could not obtain {}", (Object)autodocManifest.dependency());
            return null;
        }
        return inputStream;
    }

    @Override
    protected Optional<DependencySource> createSource(Dependency dependency) {
        if (this.isLocalFileValid(dependency)) {
            this.getLogger().debug("Local file {} was deemed to be viable, will not download", (Object)dependency);
            return Optional.empty();
        }
        List repos = this.getProject().getRepositories().stream().toList();
        return repos.stream().filter(repo -> repo instanceof MavenArtifactRepository).map(repo -> (MavenArtifactRepository)repo).map(repo -> {
            String repoUrl = this.createArtifactUrl(dependency, (MavenArtifactRepository)repo);
            try {
                DependencySource ds = DependencySourceFactory.createDependencySource(URI.create(repoUrl), dependency, "manifest", "json");
                if (ds.exists()) {
                    this.getLogger().debug("Manifest found for '{}' at {}", (Object)dependency.getName(), (Object)ds.uri());
                    return ds;
                }
                this.getLogger().debug("Manifest not found for '{}' at {}", (Object)dependency.getName(), (Object)ds.uri());
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst();
    }

    private String createArtifactUrl(Dependency dep, MavenArtifactRepository repo) {
        return String.format("%s%s/%s/%s/%s-%s-%s.%s", repo.getUrl(), dep.getGroup().replace(".", "/"), dep.getName(), dep.getVersion(), dep.getName(), dep.getVersion(), "manifest", "json");
    }

    private boolean isLocalFileValid(Dependency dep) {
        if (!this.downloadDirectory.toFile().exists()) {
            return false;
        }
        String filename = String.format("%s-%s-%s.%s", dep.getName(), dep.getVersion(), "manifest", "json");
        Path filePath = this.downloadDirectory.resolve(filename);
        File file = filePath.toFile();
        if (!file.exists() || !file.canRead()) {
            return false;
        }
        try {
            Instant date = Files.getLastModifiedTime(filePath, new LinkOption[0]).toInstant();
            return Duration.between(date, Instant.now()).compareTo(MAX_MANIFEST_AGE) <= 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

