/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.InputStream;
import java.net.URI;
import org.gradle.api.artifacts.Dependency;

public abstract class DependencySource {
    private final Dependency dependency;
    private final URI uri;
    private final String classifier;
    private final String type;

    public DependencySource(Dependency dependency, URI uri, String classifier, String type) {
        this.dependency = dependency;
        this.uri = uri;
        this.classifier = classifier;
        this.type = type;
    }

    String filename() {
        return String.format("%s-%s-%s.%s", this.dependency.getName(), this.dependency.getVersion(), this.classifier, this.type);
    }

    public abstract boolean exists();

    public Dependency dependency() {
        return this.dependency;
    }

    public URI uri() {
        return this.uri;
    }

    public String classifier() {
        return this.classifier;
    }

    public String type() {
        return this.type;
    }

    public abstract InputStream inputStream();
}

