/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.File;
import java.util.Collection;
import org.eclipse.edc.plugins.autodoc.tasks.JsonFileAppender;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.internal.GFileUtils;

public class AutodocBomTask
extends DefaultTask {
    public static final String NAME = "autodocBom";
    public static final String DESCRIPTION = "This task is intended for BOM modules. It resolves all autodoc manifests of modules that the BOM depends on\nand generates a merged manifest file. By default, this merged file is stored at {project}/build/edc.json.\n";
    private final JsonFileAppender appender = new JsonFileAppender(this.getLogger());
    private File outputFile = ((RegularFile)this.getProject().getLayout().getBuildDirectory().file(this.outputFileName()).get()).getAsFile();

    @TaskAction
    public void mergeManifests() {
        Directory inputDirectory;
        if (!this.getProject().getName().endsWith("-bom")) {
            this.getLogger().warn("Project name does not end with '-bom'. Is this really a BOM module?");
        }
        if (!(inputDirectory = (Directory)this.getProject().getLayout().getBuildDirectory().dir("autodoc").get()).getAsFile().exists()) {
            this.getLogger().info("Input directory does not exist: {}, Skipping", (Object)inputDirectory);
            return;
        }
        File destinationFile = this.outputFile;
        Collection files = GFileUtils.listFiles((File)inputDirectory.getAsFile(), (String[])new String[]{"json"}, (boolean)false);
        this.getLogger().debug("Appending [{}] additional JSON files to the merged manifest", (Object)files.size());
        files.forEach(f -> this.appender.append(destinationFile, (File)f));
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    private String outputFileName() {
        return "edc.json";
    }
}

