/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.eclipse.edc.plugins.autodoc.tasks.AbstractManifestResolveTask;
import org.eclipse.edc.plugins.autodoc.tasks.DependencySource;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependency;
import org.gradle.api.provider.Provider;

public class ResolveManifestTask
extends AbstractManifestResolveTask {
    public static final String NAME = "resolveManifests";
    public static final String DESCRIPTION = "This task is intended for BOM modules and resolves the autodoc manifests of all modules that the project depends on. By default, all manifests are stored in {project}/build/autodoc.";

    @Override
    protected InputStream resolveManifest(DependencySource autodocManifest) {
        URI uri = autodocManifest.uri();
        try {
            File file = new File(uri);
            if (file.exists()) {
                return new FileInputStream(file);
            }
            this.getLogger().info("File {} does not exist", (Object)file);
            return null;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Optional<DependencySource> createSource(Dependency dependency) {
        if (dependency instanceof DefaultProjectDependency) {
            DefaultProjectDependency localDepdendency = (DefaultProjectDependency)dependency;
            Provider manifestFile = localDepdendency.getDependencyProject().getLayout().getBuildDirectory().file("edc.json");
            if (manifestFile.isPresent()) {
                return Optional.of(new DependencySource((Dependency)localDepdendency, ((RegularFile)manifestFile.get()).getAsFile().toURI(), "manifest", "json"));
            }
            this.getLogger().debug("No manifest file found for dependency {}", (Object)dependency);
        } else {
            this.getLogger().debug("Dependency {} is not a DefaultProjectDependency", (Object)dependency);
        }
        return Optional.empty();
    }
}

