/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.edc.plugins.autodoc.tasks.AbstractManifestResolveTask;
import org.eclipse.edc.plugins.autodoc.tasks.DependencySource;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;

public class DownloadManifestTask
extends AbstractManifestResolveTask {
    public static final String NAME = "downloadManifests";
    private static final Duration MAX_MANIFEST_AGE = Duration.ofHours(24L);
    private final HttpClient httpClient = HttpClient.newHttpClient();

    @Override
    protected InputStream resolveManifest(DependencySource autodocManifest) {
        HttpResponse<InputStream> response;
        HttpRequest request = HttpRequest.newBuilder().uri(autodocManifest.uri()).GET().build();
        try {
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (response.statusCode() != 200) {
            this.getLogger().warn("Could not download {}, HTTP response: {}", (Object)autodocManifest.dependency(), response);
            return null;
        }
        return response.body();
    }

    @Override
    protected Optional<DependencySource> createSource(Dependency dependency) {
        if (this.isLocalFileValid(dependency)) {
            this.getLogger().debug("Local file {} was deemed to be viable, will not download", (Object)new DependencySource(dependency, null, "manifest", "json").filename());
            return Optional.empty();
        }
        List repos = this.getProject().getRepositories().stream().toList();
        return repos.stream().filter(repo -> repo instanceof MavenArtifactRepository).map(repo -> (MavenArtifactRepository)repo).map(repo -> {
            String repoUrl = this.createArtifactUrl(dependency, (MavenArtifactRepository)repo);
            try {
                URI uri = URI.create(repoUrl);
                HttpRequest headRequest = HttpRequest.newBuilder().uri(uri).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
                HttpResponse<Void> response = this.httpClient.send(headRequest, HttpResponse.BodyHandlers.discarding());
                if (response.statusCode() == 200) {
                    return new DependencySource(dependency, uri, "manifest", "json");
                }
                return null;
            }
            catch (IOException | IllegalArgumentException | InterruptedException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst();
    }

    private String createArtifactUrl(Dependency dep, MavenArtifactRepository repo) {
        return String.format("%s%s/%s/%s/%s-%s-%s.%s", repo.getUrl(), dep.getGroup().replace(".", "/"), dep.getName(), dep.getVersion(), dep.getName(), dep.getVersion(), "manifest", "json");
    }

    private boolean isLocalFileValid(Dependency dep) {
        if (!this.downloadDirectory.toFile().exists()) {
            return false;
        }
        Path filePath = this.downloadDirectory.resolve(new DependencySource(dep, null, "manifest", "json").filename());
        File file = filePath.toFile();
        if (!file.exists() || !file.canRead()) {
            return false;
        }
        try {
            Instant date = Files.getLastModifiedTime(filePath, new LinkOption[0]).toInstant();
            return Duration.between(date, Instant.now()).compareTo(MAX_MANIFEST_AGE) <= 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

