/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.edc.plugins.autodoc.AutodocExtension;
import org.eclipse.edc.plugins.autodoc.tasks.DependencySource;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependency;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class AbstractManifestResolveTask
extends DefaultTask {
    public static final String MANIFEST_CLASSIFIER = "manifest";
    public static final String MANIFEST_TYPE = "json";
    protected Path downloadDirectory = ((File)this.getProject().getLayout().getBuildDirectory().getAsFile().get()).toPath().resolve("autodoc");
    private File outputDirectoryOverride;

    @TaskAction
    public void resolveAutodocManifest() {
        AutodocExtension autodocExt = (AutodocExtension)this.getProject().getExtensions().findByType(AutodocExtension.class);
        Objects.requireNonNull(autodocExt, "AutodocExtension cannot be null");
        if (autodocExt.getDownloadDirectory().isPresent()) {
            this.downloadDirectory = ((File)autodocExt.getDownloadDirectory().get()).toPath();
        }
        if (this.outputDirectoryOverride != null) {
            this.downloadDirectory = this.outputDirectoryOverride.toPath();
        }
        this.getProject().getConfigurations().stream().flatMap(config -> config.getDependencies().stream()).filter(dep -> dep instanceof DefaultProjectDependency).filter(dep -> !this.getExclusions().contains(dep.getName())).map(this::createSource).filter(Optional::isPresent).forEach(dt -> this.transferDependencyFile((DependencySource)dt.get(), this.downloadDirectory));
    }

    @Option(option="output", description="CLI option to override the output directory")
    public void setOutput(String output) {
        this.outputDirectoryOverride = new File(output);
    }

    @Internal
    protected abstract InputStream resolveManifest(DependencySource var1);

    @Internal
    protected Set<String> getExclusions() {
        return Set.of();
    }

    @Internal
    protected abstract Optional<DependencySource> createSource(Dependency var1);

    private void transferDependencyFile(DependencySource dependencySource, Path downloadDirectory) {
        block13: {
            Path targetFilePath = downloadDirectory.resolve(dependencySource.filename());
            try (InputStream inputStream = this.resolveManifest(dependencySource);){
                if (inputStream == null) break block13;
                downloadDirectory.toFile().mkdirs();
                this.getLogger().debug("Downloading {} into {}", (Object)dependencySource, (Object)downloadDirectory);
                try (FileOutputStream fos = new FileOutputStream(targetFilePath.toFile());){
                    inputStream.transferTo(fos);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

