/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc;

import java.util.List;
import org.eclipse.edc.plugins.autodoc.AutodocDependencyInjector;
import org.eclipse.edc.plugins.autodoc.AutodocExtension;
import org.eclipse.edc.plugins.autodoc.tasks.AutodocBomTask;
import org.eclipse.edc.plugins.autodoc.tasks.DownloadManifestTask;
import org.eclipse.edc.plugins.autodoc.tasks.MarkdownRendererTask;
import org.eclipse.edc.plugins.autodoc.tasks.MergeManifestsTask;
import org.eclipse.edc.plugins.autodoc.tasks.ResolveManifestTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class AutodocPlugin
implements Plugin<Project> {
    public static final String GROUP_NAME = "autodoc";
    public static final String AUTODOC_TASK_NAME = "autodoc";
    private final List<String> exclusions = List.of("version-catalog", "edc-build", "module-names", "openapi-merger", "test-summary", "autodoc-plugin", "autodoc-processor", "autodoc-converters");

    public void apply(Project project) {
        AutodocExtension extension = (AutodocExtension)project.getExtensions().create("autodocextension", AutodocExtension.class, new Object[0]);
        if (!this.exclusions.contains(project.getName())) {
            project.getGradle().addListener((Object)new AutodocDependencyInjector(project, extension));
        }
        project.getTasks().register("autodoc", t -> t.dependsOn(new Object[]{"compileJava"}).setGroup("autodoc"));
        project.getTasks().register("mergeManifests", MergeManifestsTask.class, t -> t.dependsOn(new Object[]{"autodoc"}).setGroup("autodoc"));
        project.getTasks().register("doc2md", MarkdownRendererTask.ToMarkdown.class, t -> t.setGroup("autodoc"));
        project.getTasks().register("doc2html", MarkdownRendererTask.ToHtml.class, t -> t.setGroup("autodoc"));
        project.getTasks().register("downloadManifests", DownloadManifestTask.class, t -> t.setGroup("autodoc"));
        project.getTasks().register("resolveManifests", ResolveManifestTask.class, t -> {
            t.dependsOn(new Object[]{"autodoc"});
            t.setGroup("autodoc");
            t.setDescription("This task is intended for BOM modules and resolves the autodoc manifests of all modules that the project depends on. By default, all manifests are stored in {project}/build/autodoc.");
        });
        project.getTasks().register("autodocBom", AutodocBomTask.class, t -> {
            t.dependsOn(new Object[]{"resolveManifests"});
            t.setDescription("This task is intended for BOM modules. It resolves all autodoc manifests of modules that the BOM depends on\nand generates a merged manifest file. By default, this merged file is stored at {project}/build/edc.json.\n");
            t.setGroup("autodoc");
        });
    }
}

