/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.spi;

import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.edc.plugins.autodoc.spi.ManifestRenderer;
import org.eclipse.edc.runtime.metamodel.domain.EdcModule;
import org.eclipse.edc.runtime.metamodel.domain.EdcServiceExtension;

public class ManifestWriter {
    private final ManifestRenderer renderer;

    public ManifestWriter(ManifestRenderer renderer) {
        this.renderer = renderer;
    }

    public OutputStream convert(List<EdcModule> input) {
        this.beginConversion(input);
        return this.renderer.finalizeRendering();
    }

    protected void beginConversion(List<EdcModule> input) {
        this.renderer.renderDocumentHeader();
        input.forEach(this::handleModule);
    }

    protected void handleModule(EdcModule edcModule) {
        this.renderer.renderModuleHeading(edcModule.getName(), edcModule.getModulePath(), edcModule.getVersion());
        this.renderer.renderCategories(edcModule.getCategories());
        this.renderer.renderExtensionPoints(edcModule.getExtensionPoints());
        this.handleExtensions(edcModule.getExtensions());
    }

    protected void handleExtensions(Set<EdcServiceExtension> extensions) {
        this.renderer.renderExtensionHeading();
        extensions.forEach(this::handleServiceExtension);
    }

    protected void handleServiceExtension(EdcServiceExtension serviceExtension) {
        this.renderer.renderExtensionHeader(serviceExtension.getClassName(), serviceExtension.getName(), serviceExtension.getOverview(), serviceExtension.getType());
        this.renderer.renderConfigurations(serviceExtension.getConfiguration());
        this.renderer.renderExposedServices(serviceExtension.getProvides());
        this.renderer.renderReferencedServices(serviceExtension.getReferences());
    }
}

