/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.html;

import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.Text;
import j2html.tags.specialized.ArticleTag;
import j2html.tags.specialized.CodeTag;
import j2html.tags.specialized.H2Tag;
import j2html.tags.specialized.HeadTag;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TbodyTag;
import j2html.tags.specialized.TrTag;
import j2html.tags.specialized.UlTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.edc.plugins.autodoc.spi.ManifestConverterException;
import org.eclipse.edc.plugins.autodoc.spi.ManifestRenderer;
import org.eclipse.edc.runtime.metamodel.domain.ConfigurationSetting;
import org.eclipse.edc.runtime.metamodel.domain.ModuleType;
import org.eclipse.edc.runtime.metamodel.domain.Service;
import org.eclipse.edc.runtime.metamodel.domain.ServiceReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlManifestRenderer
implements ManifestRenderer {
    private final OutputStream outputStream;
    private final HeadTag head = TagCreator.head();
    private final UlTag menu = TagCreator.ul();
    private final ArticleTag content = TagCreator.article();

    public HtmlManifestRenderer(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void renderDocumentHeader() {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("style.css");){
            if (stream == null) {
                throw new IllegalArgumentException("Resource not found");
            }
            this.head.with((DomContent)TagCreator.style((String)new String(stream.readAllBytes())));
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot read style.css resource: " + exception.getMessage());
        }
    }

    @Override
    public void renderModuleHeading(@Nullable String moduleName, @NotNull String modulePath, @NotNull String version) {
        String modulePublishedName = modulePath.split(":")[1];
        UlTag ul = TagCreator.ul();
        if (moduleName != null) {
            ul.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)"Name: "), new Text(moduleName)}));
        }
        ul.with(new DomContent[]{TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)"Path: "), TagCreator.code((String)modulePath)}), TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)"Version: "), TagCreator.code((String)version)})});
        H2Tag moduleTitle = (H2Tag)TagCreator.h2((String)modulePublishedName).withId(modulePublishedName);
        ((ArticleTag)((ArticleTag)this.content.with((DomContent)TagCreator.hr())).with((DomContent)TagCreator.a((DomContent[])new DomContent[]{moduleTitle}).withHref("#" + modulePublishedName))).with((DomContent)ul);
        this.menu.with((DomContent)TagCreator.li().with((DomContent)TagCreator.a((String)modulePublishedName).withHref("#" + modulePublishedName)));
    }

    @Override
    public void renderCategories(List<String> categories) {
        String categoriesString = categories.isEmpty() ? "none" : categories.stream().filter(Objects::nonNull).filter(it -> !it.isBlank()).collect(Collectors.joining(", "));
        this.content.with((DomContent)TagCreator.em((String)("Categories: " + categoriesString)));
    }

    @Override
    public void renderExtensionPoints(List<Service> extensionPoints) {
        this.content.with((DomContent)TagCreator.h3((String)"Extension Points"));
        if (extensionPoints.isEmpty()) {
            this.content.with((DomContent)TagCreator.em((String)"none"));
        } else {
            UlTag list = TagCreator.ul();
            extensionPoints.stream().map(it -> TagCreator.li((DomContent[])new DomContent[]{TagCreator.em((String)it.getService())})).forEach(arg_0 -> ((UlTag)list).with(arg_0));
            this.content.with((DomContent)list);
        }
    }

    @Override
    public void renderExtensionHeading() {
    }

    @Override
    public void renderExtensionHeader(@NotNull String className, @Nullable String name, @Nullable String overview, ModuleType type) {
        UlTag extensionDetail = (UlTag)((UlTag)TagCreator.ul().with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)"Class: ")}).with((DomContent)TagCreator.code((String)className)))).with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)"Type: ")}).with((DomContent)TagCreator.span((String)type.getKey())));
        if (overview != null) {
            extensionDetail.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)"Overview: ")}).with((DomContent)TagCreator.span((String)overview)));
        }
        ((ArticleTag)this.content.with((DomContent)TagCreator.h3((String)("Extension " + name)))).with((DomContent)extensionDetail);
    }

    @Override
    public void renderConfigurations(List<ConfigurationSetting> configuration) {
        this.content.with((DomContent)TagCreator.h4((String)"Configuration: "));
        if (configuration.isEmpty()) {
            this.content.with((DomContent)TagCreator.em((String)"none"));
        } else {
            TrTag header = TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Key"), TagCreator.th((String)"Required"), TagCreator.th((String)"Type"), TagCreator.th((String)"Default"), TagCreator.th((String)"Pattern"), TagCreator.th((String)"Min"), TagCreator.th((String)"Max"), TagCreator.th((String)"Description")});
            TbodyTag tbody = TagCreator.tbody();
            IntStream.range(0, configuration.size()).mapToObj(index -> this.renderConfigurationRow((ConfigurationSetting)configuration.get(index), index)).forEach(arg_0 -> ((TbodyTag)tbody).with(arg_0));
            this.content.with((DomContent)((TableTag)TagCreator.table().with((DomContent)TagCreator.thead((DomContent[])new DomContent[]{header}))).with((DomContent)tbody));
        }
    }

    private TrTag renderConfigurationRow(ConfigurationSetting setting, int index) {
        CodeTag key = TagCreator.code((String)setting.getKey());
        return (TrTag)TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{setting.isDeprecated() ? TagCreator.tag((String)"s").with((DomContent)key) : key}), TagCreator.td((DomContent[])new DomContent[]{setting.isRequired() ? TagCreator.code((String)"x") : null}).attr("align", (Object)"center"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)setting.getType())}).attr("align", (Object)"center"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)setting.getDefaultValue())}), TagCreator.td((DomContent[])new DomContent[]{this.codeOrNull(setting.getPattern())}).attr("align", (Object)"center"), TagCreator.td((DomContent[])new DomContent[]{this.codeOrNull(setting.getMinimum())}).attr("align", (Object)"right"), TagCreator.td((DomContent[])new DomContent[]{this.codeOrNull(setting.getMaximum())}).attr("align", (Object)"right"), TagCreator.td((String)setting.getDescription()).attr("width", (Object)"40%")}).withClass(index % 2 == 0 ? "even" : "odd");
    }

    @Override
    public void renderProvidedServices(List<Service> provides) {
        this.content.with((DomContent)TagCreator.h4((String)"Provided Services: "));
        if (provides.isEmpty()) {
            this.content.with((DomContent)TagCreator.em((String)"none"));
        } else {
            UlTag ul = TagCreator.ul();
            provides.stream().map(Service::getService).map(TagCreator::code).map(xva$0 -> TagCreator.li((DomContent[])new DomContent[]{xva$0})).forEach(arg_0 -> ((UlTag)ul).with(arg_0));
            this.content.with((DomContent)ul);
        }
    }

    @Override
    public void renderReferencedServices(List<ServiceReference> references) {
        this.content.with((DomContent)TagCreator.h4((DomContent[])new DomContent[]{new Text("Referenced (injected) Services ("), TagCreator.em((String)"emphasized if required"), new Text("): ")}));
        if (references.isEmpty()) {
            this.content.with((DomContent)TagCreator.em((String)"none"));
        } else {
            UlTag ul = TagCreator.ul();
            references.stream().map(service -> {
                CodeTag code = TagCreator.code((String)service.getService());
                return service.isRequired() ? TagCreator.em((DomContent[])new DomContent[]{code}) : code;
            }).map(xva$0 -> TagCreator.li((DomContent[])new DomContent[]{xva$0})).forEach(arg_0 -> ((UlTag)ul).with(arg_0));
            this.content.with((DomContent)ul);
        }
    }

    @Override
    public OutputStream finalizeRendering() {
        try {
            HtmlTag html = (HtmlTag)((HtmlTag)TagCreator.html().with((DomContent)this.head)).with((DomContent)TagCreator.body().with((DomContent)TagCreator.section((DomContent[])new DomContent[]{TagCreator.nav().with((DomContent)this.menu), this.content})));
            this.outputStream.write(html.render().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new ManifestConverterException(e);
        }
        return this.outputStream;
    }

    @Nullable
    private CodeTag codeOrNull(Long value) {
        return Optional.ofNullable(value).map(Object::toString).map(TagCreator::code).orElse(null);
    }

    @Nullable
    private CodeTag codeOrNull(String value) {
        return Optional.ofNullable(value).map(TagCreator::code).orElse(null);
    }
}

