/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.markdown;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.steppschuh.markdowngenerator.Markdown;
import net.steppschuh.markdowngenerator.MarkdownElement;
import net.steppschuh.markdowngenerator.table.Table;
import net.steppschuh.markdowngenerator.text.heading.Heading;
import org.eclipse.edc.plugins.autodoc.spi.ManifestConverterException;
import org.eclipse.edc.plugins.autodoc.spi.ManifestRenderer;
import org.eclipse.edc.runtime.metamodel.domain.ConfigurationSetting;
import org.eclipse.edc.runtime.metamodel.domain.ModuleType;
import org.eclipse.edc.runtime.metamodel.domain.Service;
import org.eclipse.edc.runtime.metamodel.domain.ServiceReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownManifestRenderer
implements ManifestRenderer {
    private static final String NEWLINE = System.lineSeparator();
    private final OutputStream output;
    private final StringBuilder stringBuilder;

    public MarkdownManifestRenderer(OutputStream output) {
        this.output = output;
        this.stringBuilder = new StringBuilder();
    }

    @Override
    public void renderDocumentHeader() {
    }

    @Override
    public void renderModuleHeading(@Nullable String moduleName, @NotNull String modulePath, @NotNull String version) {
        String[] modulePathTokens = modulePath.split(":");
        String artifactId = modulePathTokens.length == 2 ? modulePathTokens[1] : modulePath;
        Heading moduleHeading = Markdown.heading((String)String.format("Module `%s`", artifactId), (int)2);
        this.stringBuilder.append(moduleHeading).append(NEWLINE);
        if (moduleName != null) {
            this.stringBuilder.append(Markdown.bold((String)"Name:")).append(" ").append(moduleName).append(NEWLINE);
        }
        this.stringBuilder.append(Markdown.bold((String)"Artifact:")).append(" ").append(modulePath).append(":").append(version).append(NEWLINE).append(NEWLINE);
    }

    @Override
    public void renderCategories(List<String> categories) {
        String cat = categories.stream().filter(c -> c != null && !c.isEmpty()).collect(Collectors.joining(", "));
        if (cat.isEmpty()) {
            cat = "None";
        }
        this.stringBuilder.append(Markdown.bold((String)"Categories:")).append(" ").append(Markdown.italic((String)cat)).append(NEWLINE);
        this.stringBuilder.append(NEWLINE);
    }

    @Override
    public void renderExtensionPoints(List<Service> extensionPoints) {
        this.stringBuilder.append(Markdown.heading((String)"Extension points", (int)3)).append(NEWLINE);
        this.stringBuilder.append(this.listOrNone(Markdown.unorderedList((Object[])extensionPoints.stream().map(s -> Markdown.code((String)s.getService())).toList().toArray()))).append(NEWLINE);
        this.stringBuilder.append(NEWLINE);
    }

    @Override
    public void renderExtensionHeading() {
        this.stringBuilder.append(Markdown.heading((String)"Extensions", (int)3)).append(NEWLINE);
    }

    @Override
    public void renderExtensionHeader(@NotNull String className, String name, String overview, ModuleType type) {
        this.stringBuilder.append(Markdown.heading((String)("Class: " + Markdown.code((String)className)), (int)4)).append(NEWLINE);
        this.stringBuilder.append(Markdown.bold((String)"Name:")).append(String.format(" \"%s\"", name)).append(NEWLINE);
        if (overview != null) {
            this.stringBuilder.append(NEWLINE).append(Markdown.bold((String)"Overview:")).append(" ").append(overview).append(NEWLINE).append(NEWLINE);
        }
        this.stringBuilder.append(NEWLINE);
    }

    @Override
    public void renderConfigurations(List<ConfigurationSetting> configuration) {
        Table.Builder tableBuilder = new Table.Builder().addRow(new Object[]{"Key", "Required", "Type", "Default", "Pattern", "Min", "Max", "Description"});
        configuration.stream().map(this::renderConfigurationSetting).forEach(arg_0 -> ((Table.Builder)tableBuilder).addRow(arg_0));
        this.stringBuilder.append(Markdown.heading((String)"Configuration", (int)3));
        if (!configuration.isEmpty()) {
            this.stringBuilder.append(NEWLINE).append(NEWLINE).append(tableBuilder.build()).append(NEWLINE);
        } else {
            this.stringBuilder.append(Markdown.italic((String)"None")).append(NEWLINE);
        }
        this.stringBuilder.append(NEWLINE);
    }

    @Override
    public void renderProvidedServices(List<Service> provides) {
        this.stringBuilder.append(Markdown.heading((String)"Provided services", (int)4)).append(NEWLINE);
        this.stringBuilder.append(this.listOrNone(provides.stream().map(s -> Markdown.code((String)s.getService())).toList().toArray())).append(NEWLINE);
        this.stringBuilder.append(NEWLINE);
    }

    @Override
    public void renderReferencedServices(List<ServiceReference> references) {
        this.stringBuilder.append(Markdown.heading((String)"Referenced (injected) services", (int)4)).append(NEWLINE);
        this.stringBuilder.append(this.listOrNone(references.stream().map(s -> String.format("%s (%s)", Markdown.code((String)s.getService()), s.isRequired() ? "required" : "optional")).toList().toArray())).append(NEWLINE);
        this.stringBuilder.append(NEWLINE);
    }

    @Override
    public OutputStream finalizeRendering() {
        try {
            this.output.write(this.stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new ManifestConverterException(e);
        }
        return this.output;
    }

    private Object @NotNull [] renderConfigurationSetting(ConfigurationSetting setting) {
        return Stream.of(setting.isDeprecated() ? Markdown.strikeThrough((String)setting.getKey()) : Markdown.code((String)setting.getKey()), setting.isRequired() ? Markdown.code((String)"*") : null, Markdown.code((String)setting.getType()), Optional.ofNullable(setting.getDefaultValue()).map(Markdown::code).orElse(null), Optional.ofNullable(setting.getPattern()).map(Markdown::code).orElse(null), Optional.ofNullable(setting.getMinimum()).map(m -> Markdown.code((String)String.valueOf(m))).orElse(null), Optional.ofNullable(setting.getMaximum()).map(m -> Markdown.code((String)String.valueOf(m))).orElse(null), setting.getDescription()).toArray();
    }

    private MarkdownElement listOrNone(Object ... items) {
        if (items.length == 0 || Arrays.stream(items).allMatch(o -> o.toString().isEmpty())) {
            return Markdown.italic((String)"None");
        }
        return Markdown.unorderedList((Object[])items);
    }
}

