/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.auth.token;

import java.util.Optional;
import java.util.UUID;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.api.auth.spi.registry.ApiAuthenticationProviderRegistry;
import org.eclipse.edc.api.auth.spi.registry.ApiAuthenticationRegistry;
import org.eclipse.edc.api.auth.token.TokenBasedAuthenticationService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;

@Extension(value="Static token API Authentication")
public class TokenBasedAuthenticationExtension
implements ServiceExtension {
    public static final String NAME = "Static token API Authentication";
    public static final String AUTH_KEY = "auth";
    public static final String CONFIG_ALIAS = "web.http.<context>.auth.";
    @Setting(context="web.http.<context>.auth.", value="The api key to use for the <context>")
    public static final String AUTH_API_KEY = "key";
    @Setting(context="web.http.<context>.auth.", value="The vault api key alias to use for the <context>")
    public static final String AUTH_API_KEY_ALIAS = "key.alias";
    public static final String TOKENBASED_TYPE = "tokenbased";
    @Setting
    @Deprecated(since="0.7.1")
    private static final String AUTH_SETTING_APIKEY = "edc.api.auth.key";
    @Setting
    @Deprecated(since="0.7.1")
    private static final String AUTH_SETTING_APIKEY_ALIAS = "edc.api.auth.key.alias";
    @Inject
    private Vault vault;
    @Inject
    private ApiAuthenticationRegistry authenticationRegistry;
    @Inject
    private ApiAuthenticationProviderRegistry providerRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        String apiKey = Optional.ofNullable(context.getSetting(AUTH_SETTING_APIKEY_ALIAS, null)).map(alias -> this.vault.resolveSecret(alias)).orElseGet(() -> context.getSetting(AUTH_SETTING_APIKEY, UUID.randomUUID().toString()));
        if (!this.authenticationRegistry.hasService("management-api")) {
            this.authenticationRegistry.register("management-api", (AuthenticationService)new TokenBasedAuthenticationService(apiKey));
        }
        this.providerRegistry.register(TOKENBASED_TYPE, this::tokenBasedProvider);
    }

    public Result<AuthenticationService> tokenBasedProvider(Config config) {
        String apiKey = Optional.ofNullable(config.getString(AUTH_API_KEY_ALIAS, null)).map(alias -> this.vault.resolveSecret(alias)).orElseGet(() -> config.getString(AUTH_API_KEY));
        return Result.success((Object)new TokenBasedAuthenticationService(apiKey));
    }
}

