/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.auth.token;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.web.spi.exception.AuthenticationFailedException;

public class TokenBasedAuthenticationService
implements AuthenticationService {
    private static final String API_KEY_HEADER_NAME = "x-api-key";
    private final String hardCodedApiKey;

    public TokenBasedAuthenticationService(String hardCodedApiKey) {
        this.hardCodedApiKey = hardCodedApiKey;
    }

    public boolean isAuthenticated(Map<String, List<String>> headers) {
        Objects.requireNonNull(headers, "headers");
        Optional<List> apiKey = headers.keySet().stream().filter(k -> k.equalsIgnoreCase(API_KEY_HEADER_NAME)).map(headers::get).findFirst();
        return apiKey.map(this::checkApiKeyValid).orElseThrow(() -> new AuthenticationFailedException("x-api-key not found"));
    }

    private boolean checkApiKeyValid(List<String> apiKeys) {
        return apiKeys.stream().anyMatch(this.hardCodedApiKey::equalsIgnoreCase);
    }
}

