/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.auth.token;

import java.util.UUID;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.api.auth.token.TokenBasedAuthenticationService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;

@Provides(value={AuthenticationService.class})
@Extension(value="Static token API Authentication")
public class TokenBasedAuthenticationExtension
implements ServiceExtension {
    public static final String NAME = "Static token API Authentication";
    @Setting
    private static final String AUTH_SETTING_APIKEY = "edc.api.auth.key";
    @Setting
    private static final String AUTH_SETTING_APIKEY_ALIAS = "edc.api.auth.key.alias";
    @Inject
    private Vault vault;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        String apiKey = null;
        String apiKeyAlias = context.getSetting(AUTH_SETTING_APIKEY_ALIAS, null);
        if (apiKeyAlias != null) {
            apiKey = this.vault.resolveSecret(apiKeyAlias);
        }
        if (apiKey == null) {
            apiKey = context.getSetting(AUTH_SETTING_APIKEY, UUID.randomUUID().toString());
        }
        context.registerService(AuthenticationService.class, (Object)new TokenBasedAuthenticationService(apiKey));
    }
}

