/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.auth.token;

import java.util.Optional;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.api.auth.spi.registry.ApiAuthenticationProviderRegistry;
import org.eclipse.edc.api.auth.token.TokenBasedAuthenticationService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;

@Extension(value="Static token API Authentication")
public class TokenBasedAuthenticationExtension
implements ServiceExtension {
    public static final String NAME = "Static token API Authentication";
    private static final String AUTH_KEY = "auth";
    private static final String CONFIG_ALIAS = "web.http.<context>.auth.";
    private static final String TOKENBASED_TYPE = "tokenbased";
    @Deprecated(since="0.12.0", forRemoval=true)
    private static final String AUTH_SETTING_APIKEY = "edc.api.auth.key";
    @Deprecated(since="0.12.0", forRemoval=true)
    private static final String AUTH_SETTING_APIKEY_ALIAS = "edc.api.auth.key.alias";
    @Setting(context="web.http.<context>.auth.", description="The api key to use for the <context>")
    public static final String AUTH_API_KEY = "key";
    @Setting(context="web.http.<context>.auth.", description="The vault api key alias to use for the <context>")
    public static final String AUTH_API_KEY_ALIAS = "key.alias";
    @Setting(description="DEPRECATED: auth key", key="edc.api.auth.key", required=false)
    @Deprecated(since="0.12.0", forRemoval=true)
    private String deprecatedApiKey;
    @Setting(description="DEPRECATED: auth key alias", key="edc.api.auth.key.alias", required=false)
    @Deprecated(since="0.12.0", forRemoval=true)
    private String deprecatedApiKeyAlias;
    @Inject
    private Vault vault;
    @Inject
    private ApiAuthenticationProviderRegistry providerRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        if (this.deprecatedApiKey != null || this.deprecatedApiKeyAlias != null) {
            String message = "Settings %s and %s have been removed".formatted(AUTH_SETTING_APIKEY, AUTH_SETTING_APIKEY_ALIAS) + ", to configure token based authentication for management api please configure it properly through the " + "`web.http.management.auth.%s` or `web.http.management.auth.%s` settings".formatted(AUTH_API_KEY, AUTH_API_KEY_ALIAS);
            context.getMonitor().severe(message, new Throwable[0]);
            throw new EdcException(message);
        }
        this.providerRegistry.register(TOKENBASED_TYPE, this::tokenBasedProvider);
    }

    public Result<AuthenticationService> tokenBasedProvider(Config config) {
        String apiKey = Optional.ofNullable(config.getString(AUTH_API_KEY_ALIAS, null)).map(alias -> this.vault.resolveSecret(alias)).orElseGet(() -> config.getString(AUTH_API_KEY));
        return Result.success((Object)new TokenBasedAuthenticationService(apiKey));
    }
}

