/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.asset.v3;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import org.eclipse.edc.api.management.schema.ManagementApiSchema;
import org.eclipse.edc.api.model.ApiCoreSchema;

@OpenAPIDefinition(info=@Info(description="This contains both the current and the new Asset API, which accepts JSON-LD and will become the standard API once the Dataspace Protocol is stable.", title="Asset API", version="v3"))
@Tag(name="Asset V3")
public interface AssetApi {
    @Operation(description="Creates a new asset together with a data address", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=AssetInputSchema.class))}), responses={@ApiResponse(responseCode="200", description="Asset was created successfully. Returns the asset Id and created timestamp", content={@Content(schema=@Schema(implementation=ApiCoreSchema.IdResponseSchema.class))}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="409", description="Could not create asset, because an asset with that ID already exists", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject createAssetV3(JsonObject var1);

    @Operation(description="Request all assets according to a particular query", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ApiCoreSchema.QuerySpecSchema.class))}), responses={@ApiResponse(responseCode="200", description="The assets matching the query", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AssetOutputSchema.class)))}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonArray requestAssetsV3(JsonObject var1);

    @Operation(description="Gets an asset with the given ID", responses={@ApiResponse(responseCode="200", description="The asset", content={@Content(schema=@Schema(implementation=AssetOutputSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An asset with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject getAssetV3(String var1);

    @Operation(description="Removes an asset with the given ID if possible. Deleting an asset is only possible if that asset is not yet referenced by a contract agreement, in which case an error is returned. DANGER ZONE: Note that deleting assets can have unexpected results, especially for contract offers that have been sent out or ongoing or contract negotiations.", responses={@ApiResponse(responseCode="204", description="Asset was deleted successfully"), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An asset with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="409", description="The asset cannot be deleted, because it is referenced by a contract agreement", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public void removeAssetV3(String var1);

    @Operation(description="Updates an asset with the given ID if it exists. If the asset is not found, no further action is taken. DANGER ZONE: Note that updating assets can have unexpected results, especially for contract offers that have been sent out or are ongoing in contract negotiations.", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=AssetInputSchema.class))}), responses={@ApiResponse(responseCode="204", description="Asset was updated successfully"), @ApiResponse(responseCode="404", description="Asset could not be updated, because it does not exist."), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public void updateAssetV3(JsonObject var1);

    @ArraySchema
    @Schema(name="AssetOutput", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"asset-id\",\n    \"properties\": {\n        \"key\": \"value\"\n    },\n    \"privateProperties\": {\n        \"privateKey\": \"privateValue\"\n    },\n    \"dataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    },\n    \"createdAt\": 1688465655\n}\n")
    public record AssetOutputSchema(@Schema(name="@id") String id, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/Asset") String type, ManagementApiSchema.FreeFormPropertiesSchema properties, ManagementApiSchema.FreeFormPropertiesSchema privateProperties, ApiCoreSchema.DataAddressSchema dataAddress, long createdAt) {
        public static final String ASSET_OUTPUT_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"asset-id\",\n    \"properties\": {\n        \"key\": \"value\"\n    },\n    \"privateProperties\": {\n        \"privateKey\": \"privateValue\"\n    },\n    \"dataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    },\n    \"createdAt\": 1688465655\n}\n";
    }

    @Schema(name="AssetInput", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"asset-id\",\n    \"properties\": {\n        \"key\": \"value\"\n    },\n    \"privateProperties\": {\n        \"privateKey\": \"privateValue\"\n    },\n    \"dataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    }\n}\n")
    public record AssetInputSchema(@Schema(name="@context", requiredMode=Schema.RequiredMode.REQUIRED) Object context, @Schema(name="@id") String id, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/Asset") String type, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) ManagementApiSchema.FreeFormPropertiesSchema properties, ManagementApiSchema.FreeFormPropertiesSchema privateProperties, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) ApiCoreSchema.DataAddressSchema dataAddress) {
        public static final String ASSET_INPUT_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"asset-id\",\n    \"properties\": {\n        \"key\": \"value\"\n    },\n    \"privateProperties\": {\n        \"privateKey\": \"privateValue\"\n    },\n    \"dataAddress\": {\n        \"type\": \"HttpData\",\n        \"baseUrl\": \"https://jsonplaceholder.typicode.com/todos\"\n    }\n}\n";
    }
}

