/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.asset.v3;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Optional;
import org.eclipse.edc.api.model.IdResponse;
import org.eclipse.edc.connector.api.management.asset.v3.AssetApi;
import org.eclipse.edc.connector.spi.asset.AssetService;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.types.domain.asset.Asset;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v3/assets")
public class AssetApiController
implements AssetApi {
    private final TypeTransformerRegistry transformerRegistry;
    private final AssetService service;
    private final Monitor monitor;
    private final JsonObjectValidatorRegistry validator;

    public AssetApiController(AssetService service, TypeTransformerRegistry transformerRegistry, Monitor monitor, JsonObjectValidatorRegistry validator) {
        this.transformerRegistry = transformerRegistry;
        this.service = service;
        this.monitor = monitor;
        this.validator = validator;
    }

    @Override
    @POST
    public JsonObject createAsset(JsonObject assetJson) {
        this.validator.validate("https://w3id.org/edc/v0.0.1/ns/Asset", assetJson).orElseThrow(ValidationFailureException::new);
        Asset asset = (Asset)this.transformerRegistry.transform((Object)assetJson, Asset.class).orElseThrow(InvalidRequestException::new);
        IdResponse idResponse = (IdResponse)this.service.create(asset).map(a -> IdResponse.Builder.newInstance().id(a.getId()).createdAt(a.getCreatedAt()).build()).orElseThrow(ServiceResultHandler.exceptionMapper(Asset.class, (String)asset.getId()));
        return (JsonObject)this.transformerRegistry.transform((Object)idResponse, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    @Override
    @POST
    @Path(value="/request")
    public JsonArray requestAssets(JsonObject querySpecJson) {
        QuerySpec querySpec;
        if (querySpecJson == null) {
            querySpec = QuerySpec.Builder.newInstance().build();
        } else {
            this.validator.validate("https://w3id.org/edc/v0.0.1/ns/QuerySpec", querySpecJson).orElseThrow(ValidationFailureException::new);
            querySpec = (QuerySpec)this.transformerRegistry.transform((Object)querySpecJson, QuerySpec.class).orElseThrow(InvalidRequestException::new);
        }
        return (JsonArray)((List)this.service.search(querySpec).orElseThrow(ServiceResultHandler.exceptionMapper(QuerySpec.class, null))).stream().map(it -> this.transformerRegistry.transform(it, JsonObject.class)).peek(r -> r.onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]))).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }

    @Override
    @GET
    @Path(value="{id}")
    public JsonObject getAsset(@PathParam(value="id") String id) {
        Asset asset = Optional.of(id).map(it -> this.service.findById(id)).orElseThrow(() -> new ObjectNotFoundException(Asset.class, id));
        return (JsonObject)this.transformerRegistry.transform((Object)asset, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    @Override
    @DELETE
    @Path(value="{id}")
    public void removeAsset(@PathParam(value="id") String id) {
        this.service.delete(id).orElseThrow(ServiceResultHandler.exceptionMapper(Asset.class, (String)id));
    }

    @Override
    @PUT
    public void updateAsset(JsonObject assetJson) {
        this.validator.validate("https://w3id.org/edc/v0.0.1/ns/Asset", assetJson).orElseThrow(ValidationFailureException::new);
        Asset assetResult = (Asset)this.transformerRegistry.transform((Object)assetJson, Asset.class).orElseThrow(InvalidRequestException::new);
        this.service.update(assetResult).orElseThrow(ServiceResultHandler.exceptionMapper(Asset.class, (String)assetResult.getId()));
    }
}

