/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.asset.validation;

import jakarta.json.JsonObject;
import org.eclipse.edc.api.validation.DataAddressValidator;
import org.eclipse.edc.validator.jsonobject.JsonObjectValidator;
import org.eclipse.edc.validator.jsonobject.validators.MandatoryObject;
import org.eclipse.edc.validator.jsonobject.validators.OptionalIdNotBlank;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;

public class AssetValidator {
    public static Validator<JsonObject> instance() {
        return JsonObjectValidator.newValidator().verifyId(OptionalIdNotBlank::new).verify("https://w3id.org/edc/v0.0.1/ns/properties", MandatoryObject::new).verify("https://w3id.org/edc/v0.0.1/ns/dataAddress", MandatoryObject::new).verify(path -> new AssetPropertiesUniqueness()).verifyObject("https://w3id.org/edc/v0.0.1/ns/dataAddress", DataAddressValidator::instance).build();
    }

    private static class AssetPropertiesUniqueness
    implements Validator<JsonObject> {
        private AssetPropertiesUniqueness() {
        }

        public ValidationResult validate(JsonObject input) {
            if (!input.containsKey((Object)"https://w3id.org/edc/v0.0.1/ns/properties") || !input.containsKey((Object)"https://w3id.org/edc/v0.0.1/ns/privateProperties")) {
                return ValidationResult.success();
            }
            JsonObject properties = input.getJsonArray("https://w3id.org/edc/v0.0.1/ns/properties").getJsonObject(0);
            JsonObject privateProperties = input.getJsonArray("https://w3id.org/edc/v0.0.1/ns/privateProperties").getJsonObject(0);
            if (properties.keySet().stream().anyMatch(arg_0 -> privateProperties.containsKey(arg_0))) {
                return ValidationResult.failure((Violation)Violation.violation((String)"cannot exists duplicated keys between 'properties' and 'privateProperties'", (String)"https://w3id.org/edc/v0.0.1/ns/properties"));
            }
            return ValidationResult.success();
        }
    }
}

