/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.asset;

import org.eclipse.edc.api.validation.DataAddressValidator;
import org.eclipse.edc.connector.controlplane.api.management.asset.v3.AssetApiController;
import org.eclipse.edc.connector.controlplane.api.management.asset.validation.AssetValidator;
import org.eclipse.edc.connector.controlplane.services.spi.asset.AssetService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Management API: Asset")
public class AssetApiExtension
implements ServiceExtension {
    public static final String NAME = "Management API: Asset";
    @Inject
    private WebService webService;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private AssetService assetService;
    @Inject
    private JsonObjectValidatorRegistry validator;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        Monitor monitor = context.getMonitor();
        this.validator.register("https://w3id.org/edc/v0.0.1/ns/Asset", AssetValidator.instance());
        this.validator.register("https://w3id.org/edc/v0.0.1/ns/DataAddress", DataAddressValidator.instance());
        TypeTransformerRegistry managementTypeTransformerRegistry = this.transformerRegistry.forContext("management-api");
        this.webService.registerResource("management", (Object)new AssetApiController(this.assetService, managementTypeTransformerRegistry, monitor, this.validator));
    }
}

