/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.observability;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.edc.api.observability.ObservabilityApi;
import org.eclipse.edc.spi.system.health.HealthCheckService;
import org.eclipse.edc.spi.system.health.HealthStatus;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/check")
public class ObservabilityApiController
implements ObservabilityApi {
    private final HealthCheckService healthCheckService;

    public ObservabilityApiController(HealthCheckService provider) {
        this.healthCheckService = provider;
    }

    @Override
    @GET
    @Path(value="health")
    public Response checkHealth() {
        HealthStatus status = this.healthCheckService.getStartupStatus();
        return this.createResponse(status);
    }

    @Override
    @GET
    @Path(value="liveness")
    public Response getLiveness() {
        HealthStatus status = this.healthCheckService.isLive();
        return this.createResponse(status);
    }

    @Override
    @GET
    @Path(value="readiness")
    public Response getReadiness() {
        HealthStatus status = this.healthCheckService.isReady();
        return this.createResponse(status);
    }

    @Override
    @GET
    @Path(value="startup")
    public Response getStartup() {
        HealthStatus status = this.healthCheckService.getStartupStatus();
        return this.createResponse(status);
    }

    private Response createResponse(HealthStatus status) {
        return status.isHealthy() ? Response.ok().entity((Object)status).build() : Response.status((int)503).entity((Object)status).build();
    }
}

