/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.observability;

import com.fasterxml.jackson.databind.DeserializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.eclipse.edc.api.observability.ObservabilityApiController;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.apiversion.ApiVersionService;
import org.eclipse.edc.spi.system.apiversion.VersionRecord;
import org.eclipse.edc.spi.system.health.HealthCheckResult;
import org.eclipse.edc.spi.system.health.HealthCheckService;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Observability API")
public class ObservabilityApiExtension
implements ServiceExtension {
    public static final String NAME = "Observability API";
    public static final String OBSERVABILITY_CONTEXT = "observability";
    private static final String API_VERSION_JSON_FILE = "observability-api-version.json";
    private final HealthCheckResult result = HealthCheckResult.Builder.newInstance().component("Observability API").build();
    @Inject
    private WebService webService;
    @Inject
    private HealthCheckService healthCheckService;
    @Inject
    private TypeManager typeManager;
    @Inject
    private ApiVersionService apiVersionService;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.webService.registerResource((Object)new ObservabilityApiController(this.healthCheckService));
        this.healthCheckService.addReadinessProvider(() -> this.result);
        this.healthCheckService.addLivenessProvider(() -> this.result);
        this.registerVersionInfo(this.getClass().getClassLoader());
    }

    private void registerVersionInfo(ClassLoader resourceClassLoader) {
        try (InputStream versionContent = resourceClassLoader.getResourceAsStream(API_VERSION_JSON_FILE);){
            if (versionContent == null) {
                throw new EdcException("Version file not found or not readable.");
            }
            Stream.of((VersionRecord[])this.typeManager.getMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(versionContent, VersionRecord[].class)).forEach(vr -> this.apiVersionService.addRecord(OBSERVABILITY_CONTEXT, vr));
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }
}

