/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.observability;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.edc.api.observability.ObservabilityApi;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.health.HealthCheckService;
import org.eclipse.edc.spi.system.health.HealthStatus;
import org.jetbrains.annotations.NotNull;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/check")
public class ObservabilityApiController
implements ObservabilityApi {
    private final HealthCheckService healthCheckService;
    @Deprecated(since="milestone8")
    private final boolean deprecated;
    private final Monitor monitor;

    public ObservabilityApiController(HealthCheckService provider, boolean deprecated, Monitor monitor) {
        this.healthCheckService = provider;
        this.deprecated = deprecated;
        this.monitor = monitor;
    }

    @Override
    @GET
    @Path(value="health")
    public Response checkHealth() {
        if (this.deprecated) {
            this.monitor.warning(this.deprecationMessage(), new Throwable[0]);
        }
        HealthStatus status = this.healthCheckService.getStartupStatus();
        return this.createResponse(status);
    }

    @Override
    @GET
    @Path(value="liveness")
    public Response getLiveness() {
        if (this.deprecated) {
            this.monitor.warning(this.deprecationMessage(), new Throwable[0]);
        }
        HealthStatus status = this.healthCheckService.isLive();
        return this.createResponse(status);
    }

    @Override
    @GET
    @Path(value="readiness")
    public Response getReadiness() {
        if (this.deprecated) {
            this.monitor.warning(this.deprecationMessage(), new Throwable[0]);
        }
        HealthStatus status = this.healthCheckService.isReady();
        return this.createResponse(status);
    }

    @Override
    @GET
    @Path(value="startup")
    public Response getStartup() {
        if (this.deprecated) {
            this.monitor.warning(this.deprecationMessage(), new Throwable[0]);
        }
        HealthStatus status = this.healthCheckService.getStartupStatus();
        return this.createResponse(status);
    }

    @NotNull
    private String deprecationMessage() {
        return "The /check/* endpoint has been moved under the 'management' context, please update your url accordingly, because this endpoint will be deleted in the next releases";
    }

    private Response createResponse(HealthStatus status) {
        return status.isHealthy() ? Response.ok().entity((Object)status).build() : Response.status((int)503).entity((Object)status).build();
    }
}

