/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.transformer;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.HashSet;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.UnexpectedTypeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToCallbackAddressTransformer
extends AbstractJsonLdTransformer<JsonObject, CallbackAddress> {
    public JsonObjectToCallbackAddressTransformer() {
        super(JsonObject.class, CallbackAddress.class);
    }

    @Nullable
    public CallbackAddress transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        CallbackAddress.Builder builder = CallbackAddress.Builder.newInstance();
        this.visitProperties(jsonObject, (key, value) -> this.setProperties((String)key, (JsonValue)value, builder, context));
        return builder.build();
    }

    private void setProperties(String key, JsonValue value, CallbackAddress.Builder builder, TransformerContext context) {
        switch (key) {
            case "https://w3id.org/edc/v0.0.1/ns/transactional": {
                builder.transactional(this.transformBoolean(value, context));
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/uri": {
                this.transformString(value, arg_0 -> ((CallbackAddress.Builder)builder).uri(arg_0), context);
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/events": {
                HashSet evt = new HashSet();
                this.visitArray(value, v -> evt.add(this.transformString((JsonValue)v, context)), context);
                builder.events(evt);
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/authKey": {
                this.transformString(value, arg_0 -> ((CallbackAddress.Builder)builder).authKey(arg_0), context);
                break;
            }
            case "https://w3id.org/edc/v0.0.1/ns/authCodeId": {
                this.transformString(value, arg_0 -> ((CallbackAddress.Builder)builder).authCodeId(arg_0), context);
                break;
            }
            default: {
                ((UnexpectedTypeBuilder)((UnexpectedTypeBuilder)context.problem().unexpectedType().type("CallbackAddress")).property(key)).expected("https://w3id.org/edc/v0.0.1/ns/transactional").expected("https://w3id.org/edc/v0.0.1/ns/uri").expected("https://w3id.org/edc/v0.0.1/ns/events").expected("https://w3id.org/edc/v0.0.1/ns/authKey").expected("https://w3id.org/edc/v0.0.1/ns/authCodeId").report();
            }
        }
    }
}

