/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.transformer;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Optional;
import java.util.Set;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromCallbackAddressTransformer
extends AbstractJsonLdTransformer<CallbackAddress, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromCallbackAddressTransformer(JsonBuilderFactory jsonFactory) {
        super(CallbackAddress.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull CallbackAddress callbackAddress, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        builder.add("@type", "https://w3id.org/edc/v0.0.1/ns/CallbackAddress").add("https://w3id.org/edc/v0.0.1/ns/transactional", callbackAddress.isTransactional()).add("https://w3id.org/edc/v0.0.1/ns/uri", callbackAddress.getUri()).add("https://w3id.org/edc/v0.0.1/ns/events", this.asArray(callbackAddress.getEvents()));
        Optional.ofNullable(callbackAddress.getAuthKey()).ifPresent(authKey -> builder.add("https://w3id.org/edc/v0.0.1/ns/authKey", authKey));
        Optional.ofNullable(callbackAddress.getAuthCodeId()).ifPresent(authCodeId -> builder.add("https://w3id.org/edc/v0.0.1/ns/authCodeId", authCodeId));
        return builder.build();
    }

    private JsonArrayBuilder asArray(Set<String> events) {
        JsonArrayBuilder bldr = this.jsonFactory.createArrayBuilder();
        events.forEach(arg_0 -> ((JsonArrayBuilder)bldr).add(arg_0));
        return bldr;
    }
}

