/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.eclipse.edc.spi.query.SortOrder;

public interface ApiCoreSchema {

    @Schema(name="DataAddress", additionalProperties=Schema.AdditionalPropertiesValue.TRUE)
    public record DataAddressSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/DataAddress") String type, @Schema(name="type") String typeProperty) {
        public static final String DATA_ADDRESS_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/DataAddress\",\n    \"type\": \"HttpData\",\n    \"baseUrl\": \"http://example.com\"\n}\n";
    }

    @Schema(name="ApiErrorDetail", example="{\n    \"message\": \"error message\",\n    \"type\": \"ErrorType\",\n    \"path\": \"object.error.path\",\n    \"invalidValue\": \"this value is not valid\"\n}\n")
    public record ApiErrorDetailSchema(String message, String type, String path, String invalidValue) {
        public static final String API_ERROR_EXAMPLE = "{\n    \"message\": \"error message\",\n    \"type\": \"ErrorType\",\n    \"path\": \"object.error.path\",\n    \"invalidValue\": \"this value is not valid\"\n}\n";
    }

    @Schema(name="IdResponse", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"id-value\",\n    \"createdAt\": 1688465655\n}\n")
    public record IdResponseSchema(@Schema(name="@id") String id, long createdAt) {
        public static final String ID_RESPONSE_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"id-value\",\n    \"createdAt\": 1688465655\n}\n";
    }

    @Schema(name="QuerySpec", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"QuerySpec\",\n    \"offset\": 5,\n    \"limit\": 10,\n    \"sortOrder\": \"DESC\",\n    \"sortField\": \"fieldName\",\n    \"filterExpression\": []\n}\n")
    public record QuerySpecSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/QuerySpec") String type, int offset, int limit, SortOrder sortOrder, String sortField, List<CriterionSchema> filterExpression) {
        public static final String QUERY_SPEC_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"QuerySpec\",\n    \"offset\": 5,\n    \"limit\": 10,\n    \"sortOrder\": \"DESC\",\n    \"sortField\": \"fieldName\",\n    \"filterExpression\": []\n}\n";
    }

    @Schema(name="Criterion", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"Criterion\",\n    \"operandLeft\": \"fieldName\",\n    \"operator\": \"=\",\n    \"operandRight\": \"some value\"\n}\n")
    public record CriterionSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/Criterion") String type, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) Object operandLeft, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String operator, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) Object operandRight) {
        public static final String CRITERION_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"Criterion\",\n    \"operandLeft\": \"fieldName\",\n    \"operator\": \"=\",\n    \"operandRight\": \"some value\"\n}\n";
    }
}

